% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbColumnInfo,DatabaseConnectorResult-method}
\alias{dbColumnInfo,DatabaseConnectorResult-method}
\title{Information about result types}
\usage{
\S4method{dbColumnInfo}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
A data.frame with one row per output field in \code{res}. Methods
MUST include \code{name}, \code{field.type} (the SQL type),
and \code{data.type} (the R data type) columns, and MAY contain other
database specific information like scale and precision or whether the
field can store \code{NULL}s.
}
\description{
Produces a data.frame that describes the output of a query. The data.frame
should have as many rows as there are output fields in the result set, and
each column in the data.frame should describe an aspect of the result set
field (field name, type, etc.)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbFetch}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
