make.Xterm <- function(variable, ncoef, derivative=0, factor=1, name=NULL) {
  #  assemble details specifying a homogeneous term 
  #  last modified 5 January 2019
  if (floor(variable) != variable || variable < 1) {
    stop("Argument VARIABLE is not a positive integer.")
  }
  if (floor(ncoef) != ncoef || ncoef < 1) {
    stop("Argument NCOEF is not a positive integer.")
  }
  if (floor(derivative) != derivative || derivative < 0) {
    stop("Argument DERIVATIVE is not a positive integer.")
  }
  XtermList <- list(variable=variable, ncoef=ncoef, derivative=derivative, 
                   factor=factor, name=name)
  return(XtermList)
}