context("itemselect_count")
test_that("itemselect works as expected on the number of selected probes",
  {
    skip_on_cran()
    skip_on_os(c("mac", "linux", "solaris"))
    datatxt <- system.file("extdata", "transcripto_sample.txt", package="DRomics")
    (o <- omicdata(datatxt, check = TRUE, norm.method = "cyclicloess"))
    (s_quad0p001 <- itemselect(o, select.method = "quadratic", FDR = 0.001))
    expect_equal(length(s_quad0p001$selectindex), 78)
    (s_quad0p05 <- itemselect(o, select.method = "quadratic", FDR = 0.05))
    expect_equal(length(s_quad0p05$selectindex), 318)
    (s_lin0p001 <- itemselect(o, select.method = "linear", FDR = 0.001))
    expect_equal(length(s_lin0p001$selectindex), 14)
    (s_lin0p05 <- itemselect(o, select.method = "linear", FDR = 0.05))
    expect_equal(length(s_lin0p05$selectindex), 90)
    (s_ANOVA0p001 <- itemselect(o, select.method = "ANOVA", FDR = 0.001))
    expect_equal(length(s_ANOVA0p001$selectindex), 55)
    (s_ANOVA0p05 <- itemselect(o, select.method = "ANOVA", FDR = 0.05))
    expect_equal(length(s_ANOVA0p05$selectindex), 203)
  })