% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_app.R
\name{launch_app}
\alias{launch_app}
\title{Launch the DQA graphical user interface (GUI)}
\usage{
launch_app(
  port = 3838,
  utils_path = system.file("demo_data/utilities", package = "DQAstats"),
  mdr_filename = "mdr_example_data.csv",
  logfile_dir = tempdir(),
  parallel = TRUE,
  ncores = 2
)
}
\arguments{
\item{port}{The port, the MIRACUM DQA Tool is running on (default: 3838)}

\item{utils_path}{The path to the utilities-folder, containing the metadata
repository files (`mdr.csv` inside the folder `MDR`), JSON files with SQL
statements (inside the folder `SQL`), config files for the database
connection (`settings_default.yml`) and the email address used for the
data map (`email.yml`), a JSON file containing site names (inside the
folder `MISC`) and a markdown template to create the PDF report
(`DQA_report.Rmd` inside the folder `RMD`).}

\item{mdr_filename}{The filename of the mdr (e.g. "mdr_example_data.csv").}

\item{logfile_dir}{Is the absolute path to the directory where the logfile
will be stored. If not path is provided the tempdir() will be used.}

\item{parallel}{A boolean. If TRUE (the default value), initializing
`future::plan("multiprocess")` before running the code.}

\item{ncores}{A integer. The number of cores to use. Caution: you would
probably like to choose a low number when operating on large datasets.
Default: 2.}
}
\value{
Executing this function returns a DQAgui shiny application.
}
\description{
Launch the DQA graphical user interface (GUI)
}
\examples{
if (interactive()) {
  launch_app()
}

}
