% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/check.dist.R
\name{check.dist}
\alias{check.dist}
\title{Check if dist is properly specified for use with sim.q, exact.q}
\usage{
check.dist(dist)
}
\arguments{
\item{dist}{list of two numeric vectors \code{x} and \code{fx}: \code{x} lists the outcomes and \code{fx} the probabilities}
}
\value{
list the supplied \code{dist}.
}
\description{
Check if dist is properly specified for use with sim.q, exact.q
}
\details{
Several functions deal with computing a probability \deqn{P(X_1 X_2 \cdots X_n > t),}
where \eqn{X_1,\ldots,X_n} are non-negative discrete random variables. The function \code{\link{exact.q}} computes this probability by explicitly evaluating the sum, while \code{\link{sim.q}} estimates the probability using importance sampling. An exact approach that can handle relatively large problems is the use of \code{\link{dists.product.pair}} and \code{\link{dist.pair.cdf}}. All functions require the distributions of the \eqn{X_i}'s to be specified as a list with of two numeric vectors \code{x} and \code{fx}, where \code{x} denotes the outcomes and \code{fx} the probabilities. The outcomes should be non-negative. Only the first outcome can be 0 and only the last outcome can be Inf. The current function checks whether the distribution is properly specified.
}
\examples{
# proper specification
dist <- list(x=c(1,2,3),fx=c(1/3,1/3,1/3))
check.dist(dist) # fine

# duplicates are not allowed
dist1 <- list(x=c(1,2,2),fx=c(0.1,0.2,0.7))
#check.dist(dist1) # would throw an error
# remove the duplicate
dist1 <- dist.unique.events(dist1)
check.dist(dist1) # fine
}

