% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{prop_to_tern_proj}
\alias{prop_to_tern_proj}
\alias{tern_to_prop_proj}
\title{Project 3-d compositional data onto x-y plane and vice versa}
\usage{
prop_to_tern_proj(data, prop, x = ".x", y = ".y")

tern_to_prop_proj(data, x, y, prop = c("p1", "p2", "p3"))
}
\arguments{
\item{data}{A data-frame containing the x-y coordinates of the points.}

\item{prop}{A character vector specifying the columns names of variable
containing the projected compositions. Default is "p1", "p2", and "p3".}

\item{x}{A character string specifying the name for the column containing
the x component of the x-y projection of the simplex.}

\item{y}{A character string specifying the name for the column containing
the y component of the x-y projection of the simplex.}
}
\value{
A data-frame with the following two columns appended (when transforming to x-y projection)
\describe{
   \item{.x (or value specified in "x")}{The x component of the x-y projection of the simplex point.}
   \item{.y (or value specified in "y")}{The y component of the x-y projection of the simplex point.}
   }

A data-frame with the following three columns appended (when transforming to compositional projection)
\describe{
   \item{p1 (or first value specified in "prop")}{The first component of the 3-d simplex point.}
   \item{p2 (or second value specified in "prop")}{The second component of the 3-d simplex point.}
   \item{p3 (or third value specified in "prop")}{The third component of the 3-d simplex point.}
   }
}
\description{
Points in the 3-d simplex space with coordinates (x, y ,z) such that
x + y + z = 1 are projected into the 2-d plane they reside in. This function
can be used to convert the 3-d compositional data into 2-d and then be overlayed
on the plots output by \code{\link{ternary_plot}},
\code{\link{conditional_ternary_plot}} and \code{\link{grouped_ternary_plot}}.
}
\examples{
## Convert proportions to x-y co-ordinates
library(DImodels)
data(sim0)
sim0 <- sim0[1:16, ]

prop_to_tern_proj(data = sim0, prop = c("p1", "p2", "p3"))

# Change names of the x and y projections
prop_to_tern_proj(data = sim0, prop = c("p1", "p2", "p3"),
                  x = "x-proj", y = "y-proj")
## Convert x-y co-ordinates to proportions
library(DImodels)
data(sim0)
sim0 <- sim0[1:16, ]

proj_data <- prop_to_tern_proj(data = sim0, prop = c("p1", "p2", "p3"))

tern_to_prop_proj(data = proj_data, x = ".x", y = ".y")

# Change prop names
tern_to_prop_proj(data = proj_data, x = ".x", y = ".y",
                  prop = c("prop1", "prop2", "prop3"))
}
