% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCDIF.R
\name{CalculateItemDifferences}
\alias{CalculateItemDifferences}
\title{Calculates the differences between two item option characteristic curves for all options (minus one).}
\usage{
CalculateItemDifferences(thetaValue, itemParameters, irtModel = "2pl",
  logistic = TRUE)
}
\arguments{
\item{thetaValue}{A numeric value or array for the theta (ability) value(s) for which the difference will be calculated}

\item{itemParameters}{A list containing "focal" and "reference" item parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should me a matrix with nrow equal to the number of items.}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric.}
}
\value{
difference A numeric matrix with the differences on probabilities or on expected score for each item between focal and reference groups.
}
\description{
Calculates the differences between two item option characteristic curves for all options (minus one).
}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}

