\name{The decomposed PaF income polarization index}
\alias{paf2}
\title{
The decomposed PaF income polarization index
}

\description{
The decomposed PaF income polarization index
}

\usage{
paf2(y, a)
}

\arguments{
\item{y}{
A numeric vector with income data.
}
\item{a}{
The value of \eqn{\alpha}. This can either be a number or a vector with many values. In any case, the \eqn{\alpha} may take values between 0.25 and 1.
}
}

\details{
The function compute the decomposed PaF index of Duclos, Esteban and Ray (2004) for either a specific value, or for a range of values, of \eqn{\alpha}. The decomposition is with respect to the deprivation and surplus components as suggested by Araar (2008).
}

\value{
For a single value of \eqn{\alpha}, the function returns a vector with the PaF index, the deprivation and the surplus components. If a range of values of \eqn{\alpha} are given, it will return a matrix with the same components, where each row corresponds to a specific value of \eqn{\alpha}.
}

\references{
Araar A. (2008). On the Decomposition of Polarization Indices: Illustrations with Chinese and Nigerian Household Surveys. CIRPEE Working Paper No. 08-06.
https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1136142

Duclos J. Y., Esteban, J. and Ray D. (2004). Polarization: concepts, measurement, estimation. Econometrica, 72(6): 1737--1772.
}

\author{
Michail Tsagris.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{colpafs2}, \link{paf}
}
}

\examples{
y <- rgamma(100, 10, 0.01)
paf(y, 0.25)
paf2( y, 0.25)
}
