% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_survival_sigma2.R
\name{DDPGP_meansurvival}
\alias{DDPGP_meansurvival}
\title{Posterior mean survival estimation using Gibbs MCMC Outputs}
\usage{
DDPGP_meansurvival(mcmc, new_pat, if_plot = 0, quantiles = c(0.025, 0.975),
  cov_col = 1)
}
\arguments{
\item{mcmc}{A list-The MCMC output from mcmc_Gibbs.}

\item{new_pat}{A matrix consisting of the covariates of new sample points. Each row represents one sample point.
It can also be vector consisting of the covariates of a new sample point.}

\item{if_plot}{A logical variable indicating whether the mean survival estimation should be plotted.
1 means estimation should be plotted; 0 means otherwise. Defualt value is 0, i.e. not plotted.}

\item{quantiles}{A two-dimensional vector determining the quantiles for the confidence bounds to be plotted. The 
first value is the lower quantile and the second value is the upper quantile. Default is (0.025,0.975)}

\item{cov_col}{An integer defining which covariate column in new_pat to plot on the x-axis for the mean survival figure.}
}
\value{
A list composed of the estimation for the mean survival across the values for the covariate specified.
The mean_survival is the average of the mean survival calculuation for all iterations, and lower_quant and upper_quant
is that for the quantiles specified. optimal is the optimal covariate value (which is specified in cov_col).
meansurvival_all is the mean survival for all iterations.
}
\description{
Posterior mean survival estimation using Gibbs MCMC Outputs
}
\examples{
########################################
#Source dependent packages
library(MASS)
library(mc2d)
library(mvnfast)
library(survival)
#Simulate Data using built-in data generation
##
seed=1
set.seed(seed)
Npat=5
data <- simulate_data(Npat)

########################################
#Run MCMC 
########################################
#Inputs for mcmc 
response <- log(data$OS)
covariate <- cbind(scale(data$Age),data$AUC,data$CR)
censor_status <- data$death
mcmc_settings<-NULL
mcmc_settings$nskip<-10
mcmc_settings$nburn<-50
mcmc_settings$ndisplay<-100
mcmc_settings$nsave<-20
mcmc_settings$sigma_jump<-c(0,4,2.5,4,2.6)
###################
#Run MCMC function
mcmc_Gibbs<-mcmc_DDPGP(response,covariate,censor_status,mcmc_settings)
########################################
#Plotting Mean Survival Estimation 
########################################
#Parameters in Plotting Mean Survival Estimation 
example_CR <- 1
example_Age <- 1
range_AUC <- seq(2.6, 7, 0.1)
new_pat_1<-cbind(example_Age,range_AUC,example_CR)
if_plot=1
DPGP_mean<-DDPGP_meansurvival(mcmc_Gibbs,new_pat_1,if_plot,cov_col=2)

}
