% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods_LM_SM.R
\name{summary.sarma}
\alias{summary.sarma}
\alias{summary.sfarima}
\title{Summarizing SARMA/SFARIMA Estimation or Simulation}
\usage{
\method{summary}{sarma}(object, ...)

\method{summary}{sfarima}(object, ...)
}
\arguments{
\item{object}{an object of class "sarma" or "sfarima", usually a result of a
call to the estimation functions \code{\link{sarma.est}}, 
\code{\link{sfarima.est}} or to the corresponding simulation functions 
\code{\link{sarma.sim}} and \code{\link{sfarima.sim}}.}

\item{...}{Additional arguments passed to the \code{summary.sarma}/
\code{summary.sfarima} function.}
}
\value{
The function \code{summary.sarma}/\code{summary.sfarima} returns an 
object of class \code{summary_sarma} including \tabular{ll}{
 \code{model} \tab estimated or simulated model parameters including 
 coefficient matrices \code{ar}, \code{ma}, the error term standard deviation
 \code{sigma} and the vector of long memory parameters \code{d} 
 (\code{summary.sarma} only)  \cr
 \code{model_order} \tab order of the estimated/simulated model computed from 
 the matrices \code{ar}, \code{ma}. \cr
 \code{stnry} \tab a flag for stationarity of the short memory part. \cr
 \code{subclass} \tab a flag indicating whether the object inherits from an
 estimation (\code{subclass = "est"}) or simulation procedure 
 (\code{subclass = "sim"}). \cr
}
}
\description{
\code{summary} method for class "sarma" or "sfarima"
}
\section{Details}{

\code{summary.sarma}/\code{summary.sfarima} strips an object of class
"sarma"/"sfarima" from all large matrices (\code{Y}, \code{innov}), allowing
 for easier handling of meta-statistics of the bandwidth selection procedure.

 \code{print.summary_sarma}/\code{print.summary_sarma} returns a list of 
 summary statistics from the estimation or simulation procedure.
}

\examples{
# SARMA Simulation and Estimation
ma = matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar = matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
sigma = 0.5
sarma_model = list(ar = ar, ma = ma, sigma = sigma)
sarma_sim = sarma.sim(100, 100, model = sarma_model)
summary(sarma_sim)
sarma_est = sarma.est(sarma_sim$Y)
summary(sarma_est)

# SFARIMA Simulation and Estimation
ma = matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar = matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
d = c(0.1, 0.1)
sigma = 0.5
sfarima_model = list(ar = ar, ma = ma, d = d, sigma = sigma)
sfarima_sim = sfarima.sim(100, 100, model = sfarima_model)
summary(sfarima_sim)
sfarima_est = sfarima.est(sfarima_sim$Y)
summary(sfarima_est)

}
\seealso{
\code{\link{sarma.est}, \link{sfarima.est}, \link{sarma.sim},
 \link{sfarima.sim}}
}
