% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcpo.R
\name{dcpo}
\alias{dcpo}
\title{Estimate Dynamic Comparative Public Opinion}
\usage{
dcpo(dcpo_input, chime = TRUE, ...)
}
\arguments{
\item{dcpo_input}{a data frame of survey items and marginals generated by \code{DCPOtools::dcpo_setup}}

\item{chime}{play chime when complete?}

\item{...}{arguments to be passed to \code{rstan::stan}. Defaults reset by \code{dcpo} are
described below under details.}
}
\value{
a stanfit object
}
\description{
\code{dcpo} uses diverse survey data to estimate public opinion across countries and over time.
}
\details{
\code{dcpo}, when passed a data frame \code{dcpo_input} of survey marginals created
by \code{dcpo_setup}, estimates a latent variable of public opinion.  See \code{rstan::stan} for
additional options; \code{stan} defaults reset by \code{dcpo} are \code{seed = 324, thin = 2,}
\code{cores = min(stan_args$chains, parallel::detectCores()/2),} and \code{control <- list(adapt_delta = 0.99, stepsize = 0.005, max_treedepth = 14)}
}
\examples{
\donttest{
out1 <- dcpo(demsup_data,
             chains = 2,
             iter = 300) # 2 chains/300 iterations for example purposes only; use defaults
}

}
