% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_exact_power.R
\name{calc_exact_power}
\alias{calc_exact_power}
\title{calc_exact_power.R}
\usage{
calc_exact_power(bounds, sig_mat, muVec)
}
\arguments{
\item{bounds}{A d=J*1 vector of bounds on the magnitudes of the test statistics, where
the first element is the bound for |Z|_(1) and the last element is the bound for |Z|_(J).}

\item{sig_mat}{The covariance matrix of the test statistics under the alternative (assume multivariate normal).}

\item{muVec}{The mean vector of the test statistics under the alternative (assume multivariate normal).}
}
\value{
A list with the elements:
\item{power}{Power under the given alternative.}
\item{errsum}{Largest possible error from integration.}
\item{naSum}{Number of NAs in calculating all integrals.}
\item{sumOverA}{Matrix with power, errsum, naSum for each partition of the rejection region.}
}
\description{
For detection boundary type tests, find the power given the rejection region bounds and
specification of alternative. Do not use for sets larger than 5 elements, will be too slow.
}
\examples{
\donttest{
myCov <- matrix(data=0.3, nrow=5, ncol=5)
diag(myCov) <- 1
myBounds <- set_GBJ_bounds(alpha = 0.01, J=5, sig_vec = myCov[lower.tri(myCov)])
calc_exact_power(bounds = myBounds, sig_mat = myCov, muVec = c(1, 0, 0, 0, 0))
}
}
