% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{scaleDataFrame}
\alias{scaleDataFrame}
\title{Standardize quantitative variables in a data frame}
\usage{
scaleDataFrame(data, numsd = 1, nvals_fac = 11, exclude = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{numsd}{Number of standard deviations to divide by - defaults to 1.}

\item{nvals_fac}{Number of unique values required to standardize - variables with fewer than `nvals_fac` unique values will not be standardized.}

\item{exclude}{A character vector of names of variables to exclude from the standardization.}
}
\value{
A data frame with standardized quantitative variables
}
\description{
This function standardizes quantitative variables in a data frame while
leaving the others untouched.  This leaves not only factors, but also binary
variables (those with values 0, 1, or NA).
}
\author{
Dave Armstrong
}
