% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{inspect}
\alias{inspect}
\alias{inspect.data.frame}
\alias{inspect.tbl_df}
\title{Inspect a Variable in a Data Frame}
\usage{
inspect(data, x, includeLabels = FALSE, ...)
}
\arguments{
\item{data}{A data frame of class \code{data.frame} or \code{tbl_df}.}

\item{x}{A string identifying the name of the variable to be inspected.}

\item{includeLabels}{Logical indicating whether value labels should also be included.}

\item{...}{Other arguments to be passed down, currently unimplemented.}
}
\value{
A list with a variable label (if present), factor levels/value
labels (if present) and a frequency distribution
}
\description{
Shows the variable label, factor levels (i.e., value labels) and frequency
distribution for the specified variable.
}
\examples{

data(france)
inspect(france, "vote")

}
\author{
Dave Armstrong
}
