% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{aspect_importance}
\alias{aspect_importance}
\alias{aspect_importance.explainer}
\alias{aspect_importance.default}
\alias{lime}
\title{Calculates the feature groups importance (called aspects importance) for a
selected observation}
\usage{
aspect_importance(x, ...)

\method{aspect_importance}{explainer}(
  x,
  new_observation,
  aspects,
  N = 100,
  sample_method = "default",
  n_var = 0,
  f = 2,
  show_cor = FALSE,
  ...
)

\method{aspect_importance}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  aspects,
  N = 100,
  label = class(x)[1],
  sample_method = "default",
  n_var = 0,
  f = 2,
  show_cor = FALSE,
  ...
)

lime(x, ...)
}
\arguments{
\item{x}{an explainer created with the \code{DALEX::explain()} function
or a model to be explained.}

\item{...}{other parameters}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model}

\item{aspects}{list containting grouping of features into aspects}

\item{N}{number of observations to be sampled (with replacement) from data}

\item{sample_method}{sampling method in \code{\link{get_sample}}}

\item{n_var}{maximum number of non-zero coefficients after lasso fitting,
if zero than linear regression is used}

\item{f}{frequency in \code{\link{get_sample}}}

\item{show_cor}{show if all features in aspect are pairwise positivly
correlated, works only if dataset contains solely numeric values}

\item{data}{dataset, it will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{predict_function}{predict function, it will be extracted from \code{x}
if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class'
attribute of the model.}
}
\value{
An object of the class \code{aspect_importance}. Contains dataframe
  that describes aspects' importance.
}
\description{
Aspect Importance function takes a sample from a given dataset and modifies
it. Modification is made by replacing part of its aspects by values from the
observation. Then function is calculating the difference between the
prediction made on modified sample and the original sample. Finally, it
measures the impact of aspects on the change of prediction by using the
linear model or lasso.
}
\examples{
library("DALEX")
library("ingredients")

titanic_imputed$country <- NULL

model_titanic_glm <- glm(survived == "yes" ~
                         class+gender+age+sibsp+parch+fare+embarked,
                         data = titanic_imputed,
                         family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed$survived == "yes",
                               verbose = FALSE)

aspects <- list(wealth = c("class", "fare"),
                family = c("sibsp", "parch"),
                personal = c("gender", "age"),
                embarked = "embarked")

aspect_importance(explain_titanic_glm,
                  new_observation = titanic_imputed[1,],
                  aspects = aspects)

\donttest{
library("randomForest")
model_titanic_rf <- randomForest(survived ~ class + gender + age + sibsp +
                                 parch + fare + embarked,
                                 data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed$survived == "yes",
                              verbose = FALSE)

aspect_importance(explain_titanic_rf,
                  new_observation = titanic_imputed[1,],
                  aspects = aspects)

}

}
