% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.Trainset.R
\name{Trainset}
\alias{Trainset}
\title{Trainning set.}
\description{
The \code{\link{Trainset}} is used to perform training
operations over M.L. models. A target class should be defined to guarantee a
full compatibility with supervised models.
}
\details{
Use \code{\link{Dataset}} object to ensure the creation of a valid
\code{\link{Trainset}} object.
}
\seealso{
\code{\link{Dataset}}, \code{\link{DatasetLoader}},
\code{\link{Subset}}, \code{\link{GenericClusteringStrategy}}
}
\keyword{attribute}
\keyword{datasets}
\keyword{manip}
\keyword{programming}
\keyword{utilities}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Trainset-new}{\code{Trainset$new()}}
\item \href{#method-Trainset-getPositiveClass}{\code{Trainset$getPositiveClass()}}
\item \href{#method-Trainset-getClassName}{\code{Trainset$getClassName()}}
\item \href{#method-Trainset-getClassValues}{\code{Trainset$getClassValues()}}
\item \href{#method-Trainset-getColumnNames}{\code{Trainset$getColumnNames()}}
\item \href{#method-Trainset-getFeatureValues}{\code{Trainset$getFeatureValues()}}
\item \href{#method-Trainset-getInstances}{\code{Trainset$getInstances()}}
\item \href{#method-Trainset-getNumClusters}{\code{Trainset$getNumClusters()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-new"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$new(cluster.dist, class.name, class.values, positive.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cluster.dist}}{The type of cluster distribution used as basis
to build the \code{\link{Trainset}}. See
\code{\link{GenericClusteringStrategy}} for more information.}

\item{\code{class.name}}{Used to specify the name of the column containing the
target class.}

\item{\code{class.values}}{Specifies all the possible values of the target class.}

\item{\code{positive.class}}{A \link{character} with the value of the
positive class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
The function is used to obtain the value of the positive
class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} value with the positive class value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getClassName"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getClassName}{}}}
\subsection{Method \code{getClassName()}}{
The function is used to return the name of the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector with length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getClassValues"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getClassValues}{}}}
\subsection{Method \code{getClassValues()}}{
The function is used to compute all the possible target class
values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getClassValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{factor} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getColumnNames"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getColumnNames}{}}}
\subsection{Method \code{getColumnNames()}}{
The function returns the name of the columns comprising
an specific cluster distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getColumnNames(num.cluster)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num.cluster}}{A \link{numeric} value used to specify the cluster
number of the cluster distribution used when creating the
\code{\link{Trainset}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{character} vector with all column names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getFeatureValues"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getFeatureValues}{}}}
\subsection{Method \code{getFeatureValues()}}{
The function returns the values of the columns comprising
an specific cluster distribution. Target class is omitted.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getFeatureValues(num.cluster)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num.cluster}}{A \link{numeric} value used to specify the cluster
number of the cluster distribution used when creating the
\code{\link{Trainset}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{data.frame} with the values of the features comprising
the selected cluster distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getInstances"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getInstances}{}}}
\subsection{Method \code{getInstances()}}{
The function returns the values of the columns comprising
an specific cluster distribution. Target class is included as the last
column.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getInstances(num.cluster)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num.cluster}}{A \link{numeric} value used to specify the cluster
number of the cluster distribution used when creating the
\code{\link{Trainset}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{data.frame} with the values of the features comprising
the selected cluster distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Trainset-getNumClusters"></a>}}
\if{latex}{\out{\hypertarget{method-Trainset-getNumClusters}{}}}
\subsection{Method \code{getNumClusters()}}{
The function obtains the number of groups (clusters) that
forms the cluster distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Trainset$getNumClusters()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector of size 1.
}
}
}
