#' Arterial pressure data of crossover design
#'
#' Data of a crossover experiment with three treatments to control arterial
#' pressure: treatment A is a placebo, treatments B and C are 20 and 40 mg doses
#'  of a test drug.
#'  Thus, there were six three-period sequences: ABC, ACB, BCA, BAC, CAB
#'   and CBA, each one of them was applied to two individuals lasting six
#'    weeks each. Due to ethical reasons, there  was no washout period between
#'     the treatments. In each period, 10 consecutive measurements
#'      of diastolic arterial pressure were taken: 30 and 15 minutes before,
#'      and 15, 30, 45, 60, 75, 90, 120 and 240 minutes after
#'      the administration of the treatment
#'@format A data frame with 360 rows and 5 columns:
#'\describe{
#' \item{Subject}{The unique identifier of each of the patients}
#' \item{Period}{The period of application of each treatment}
#' \item{Treatment}{A is a placebo, treatments B and C are 20 and 40 mg doses
#'  of a test drug}
#' \item{Pressure}{diastolic arterial pressure}
#' \item{Time}{Measurement time}
#'}
#'@source Jones, B. and Kenward, M. G. (2015). Design and Analysis of Cross-Over
#' Trials Third Edition. Chapman &
#' Hall/CRC, Boca Raton
"Arterial"
