% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_isb_splsdrcox.R
\name{isb.splsdrcox_penalty}
\alias{isb.splsdrcox_penalty}
\title{Iterative single-block sPLS-DRCOX}
\usage{
isb.splsdrcox_penalty(
  X,
  Y,
  cv.isb,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{List of numeric matrices or data.frames. Explanatory variables. If the variables are qualitative,
they must be transformed into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables with two columns: "time" and "event".
Accepted values for the event column are 0/1 or FALSE/TRUE for censored and event observations, respectively.}

\item{cv.isb}{Instance of class "Coxmos" and model "cv.iSB.sPLS-DRCOX-Dynamic". Used to retrieve the
optimal components and variables for the sPLS Cox model.}

\item{x.center}{Logical. If TRUE, the X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If TRUE, the X matrix is scaled to unit variance (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If TRUE, near-zero variance variables are removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If TRUE, zero-variance variables are removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Names of variables in X to retain despite near-zero variance filtering (default: NULL).}

\item{remove_non_significant}{Logical. If TRUE, non-significant variables/components in the final Cox model
are removed through forward selection (default: FALSE).}

\item{alpha}{Numeric. Significance threshold (default: 0.05).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) for the final Cox model. Limits the
number of variables/components allowed (default: 5).}

\item{returnData}{Logical. If TRUE, returns the original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If TRUE, extra messages will be displayed (default: FALSE).}
}
\value{
An object of class "Coxmos" and model "isb.splsdrcox", containing:
\itemize{
\item \code{X}: List with normalized X data:
\itemize{
\item \code{data}: Normalized X matrix (or NA if not returned).
\item \code{x.mean}: Mean values of the X matrix.
\item \code{x.sd}: Standard deviations of the X matrix.
}
\item \code{Y}: List with normalized Y data:
\itemize{
\item \code{data}: Normalized Y matrix.
\item \code{y.mean}: Mean values of the Y matrix.
\item \code{y.sd}: Standard deviations of the Y matrix.
}
\item \code{survival_model}: Fitted survival model (Cox proportional hazards model).
\item \code{list_spls_models}: List of sPLS models computed for each block.
\item \code{n.comp}: Number of components selected.
\item \code{n.varX}: Number of variables selected per block.
\item \code{call}: Function call.
\item \code{X_input}: Original X matrix (or NA if not returned).
\item \code{Y_input}: Original Y matrix (or NA if not returned).
\item \code{alpha}: Significance threshold used.
\item \code{nsv}: Variables removed due to non-significance.
\item \code{nzv}: Variables removed due to near-zero variance.
\item \code{nz_coeffvar}: Variables removed due to near-zero coefficient of variation.
\item \code{class}: Model class.
\item \code{time}: Time taken to run the analysis.
}
}
\description{
This function performs a single-block sparse partial least squares deviance residual
Cox analysis (sPLS-DRCOX) using the optimal components and variables identified in a previous
cross-validation process. It builds the final model based on the selected hyperparameters.
}
\details{
The \code{isb.splsdrcox_penalty} function fits a single-block sPLS-DRCOX model using the input data
and the optimal components and variables determined from cross-validation. The function allows
for centering and scaling of the data, and it offers the option to remove variables with near-zero
variance, zero variance, or those that are non-significant based on a specified alpha level.

This method is particularly suited for high-dimensional data where there are many more variables
than observations. The function can handle multiple blocks of data, and integrates them into a
single model for Cox proportional hazards analysis.
}
\examples{
data("X_multiomic")
data("Y_multiomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_multiomic$event, p = .25, list = FALSE, times = 1)
X_train <- X_multiomic
X_train$mirna <- X_train$mirna[index_train,1:30]
X_train$proteomic <- X_train$proteomic[index_train,1:30]
Y_train <- Y_multiomic[index_train,]
cv <- cv.isb.splsdrcox_penalty(X_train, Y_train, max.ncomp = 1, penalty.list = c(0, 0.5),
n_run = 1, k_folds = 3)
model <- isb.splsdrcox_penalty(X_train, Y_train, cv)
}
