% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursive_tree.R
\name{recursive_tree}
\alias{recursive_tree}
\title{decision tree in a recursive way}
\usage{
recursive_tree(data = data, Y = "Y", modele = NULL, kill = NULL,
  index = NULL, print = TRUE, plot = TRUE, main = NULL, sub = NULL,
  lang = c("en", "fr"), all = FALSE, digits = getOption("digits") - 3)
}
\arguments{
\item{data}{the dataset including the response}

\item{Y}{the name of the response}

\item{modele}{(optional) vector of names of covariates allowed in the tree}

\item{kill}{vector of the names to kill (variables won't be used in the tree)}

\item{index}{to give a number to the plot}

\item{print}{boolean to print the tree parameters}

\item{plot}{boolean to plot the tree}

\item{main}{the main title if plot=TRUE}

\item{sub}{the subtitle (if NULL it is automatically added)}

\item{lang}{the language for the automatic subtitle in the plot}

\item{all}{Logical. If TRUE, all nodes are labeled, otherwise just terminal nodes.}

\item{digits}{number of digits for legend of the leaves}
}
\value{
returns the tree as an "rpart" object and the modele as a vector of the names of the covariates the tree could have used (to give as an input of the function).
\item{modele}{ vector of the names of the covariates the tree could have used} 
\item{tree}{ the regression tree as an "rpart" object}
}
\description{
decision tree in a recursive way
}
\examples{
   \dontrun{
   data<-mtcars
   require(CorReg)
main="Regression tree of cars consumption (in mpg)"
  mytree=recursive_tree(data = data,Y ="mpg" ,main=main)
   #want to try without cylinder and disp
  mytree2=recursive_tree(data = data,Y ="mpg" ,kill=c("cyl","disp"),modele=mytree$modele,main=main)
  
    }
}
