% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnanimityGame.R
\name{unanimityGameVector}
\alias{unanimityGameVector}
\title{Compute game vector for a unanimity game}
\usage{
unanimityGameVector(n, T)
}
\arguments{
\item{n}{represents the number of players}

\item{T}{represents coalition which is subset of grand coalition N and neccessary for generating value}
}
\value{
Game Vector where each element contains \code{1} if all players of coalition 'T' are included in 'S'
else \code{0}
}
\description{
\strong{Game Vector for a specified unanimity game:}\cr
For further information see \link{unanimityGame}
}
\examples{
library(CoopGame)
unanimityGameVector(n=3,T=c(2))

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 152

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 764
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
