% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidWeightVector}
\alias{stopOnInvalidWeightVector}
\title{Parameter Function stopOnInvalidWeightVector}
\usage{
stopOnInvalidWeightVector(paramCheckResult, n, w)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{n}{represents the number of players}

\item{w}{numeric vector which contains the weight of each player}
}
\description{
stopOnInvalidWeightVector checks if weight vector 
 in a weighted voting game is specified correctly.
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1110 \tab Number of weights must be equal or greater than number of players in coalition!  \cr
1111 \tab Invalid weight vector as w is not numeric }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validWeightVector = c(1,2,3)
stopOnInvalidWeightVector(paramCheckResult, n=3, w=validWeightVector)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
