% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpIndexConcept.R
\name{publicHelpIndex}
\alias{publicHelpIndex}
\alias{publicHelpThetaIndex}
\alias{publicHelpIndexTheta}
\title{Compute Public Help index Theta}
\usage{
publicHelpIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Public Help index Theta for specified simple game
}
\description{
Calculates the Public Help index Theta for a specified simple TU game.
Note that the Public Help index Theta goes back to the paper by Bertini, 
Gambarelli and Stach (2008) and is frequently simply referred to referred 
to Public Help index in the literature.
}
\examples{
library(CoopGame)
publicHelpIndex(v=c(0,0,0,0,1,0,1))

\donttest{
#Example from paper by Stach (2016), p. 105:
library(CoopGame)
v=c(0,0,0,1,1,0,1)
publicHelpIndex(v) 
#result: 0.4285714 0.2857143 0.2857143

#Second example from paper by Stach (2016), p. 105:
library(CoopGame)
v=c(0,0,0,0,1,1,0,0,0,0,1,1,1,0,1)
publicHelpIndex(v)
#result: 0.3529412 0.2352941 0.2352941 0.1764706
}

}
\references{
Bertini C., Gambarelli G. and Stach I. (2008) "A public help index", In: Braham, M. and Steffen, F. (Eds): Power, freedom, and voting: Essays in Honour of Manfred J. Holler, pp. 83--98

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25

Stach I. (2016) "Power Measures and Public Goods", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXIII, Springer, pp. 99--110
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
