% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyMonotonicity.R
\name{isMonotonicGame}
\alias{isMonotonicGame}
\title{Check if game is monotonic}
\usage{
isMonotonicGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is monotonic, else \code{FALSE}
}
\description{
Checks if a TU game with n players is monotonic. \cr
For a monotonic game a coalition \code{S} can never obtain 
a larger value than another coalition \code{T} if \code{S}
is contained in \code{T}.
}
\examples{
library(CoopGame)
isMonotonicGame(c(0,0,0,1,0,1,1))

\donttest{
#Example of a non-monotonic game
library(CoopGame)
v1=c(4,2,5,2,3,6,10)
isMonotonicGame(v1)

#Example of a monotonic game
library(CoopGame)
v2=c(2,5,7,10, 9, 13,20)
isMonotonicGame(v2)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 12

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 408
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
