% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWinningCoalitions.R
\name{getWinningCoalitions}
\alias{getWinningCoalitions}
\title{Compute winning coalitions in a simple game}
\usage{
getWinningCoalitions(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
A data frame containing all winning coalitions for a simple game.
}
\description{
The function getWinningCoalitions identifies 
all winning coalitions of a specified simple game.
}
\examples{
library(CoopGame)
getWinningCoalitions(v=c(0,0,0,1,0,1,1))

\donttest{
library(CoopGame)
v=weightedVotingGameVector(n=3,w=c(1,2,3),q=5)
getWinningCoalitions(v)
# Output:
#   V1 V2 V3 cVal
# 6  0  1  1    1
# 7  1  1  1    1
# => the coalition containing player 2 and 3 and 
#    the grand coalition are winning coalitions
}

}
\references{
Bertini C., Gambarelli G. and Stach I. (2008) "A public help index", In: Braham, M. and Steffen, F. (Eds): Power, freedom, and voting: Essays in Honour of Manfred J. Holler, pp. 83--98

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25

Stach I. (2016) "Power Measures and Public Goods", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXIII, Springer, pp. 99--110
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
