% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatelyConcept.R
\name{gatelyValue}
\alias{gatelyValue}
\alias{gatelyPoint}
\title{Compute Gately point}
\usage{
gatelyValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Gately point of the TU game or NULL in case the Gately point is not defined
}
\description{
gatelyValue calculates the Gately point for a given TU game
}
\examples{
library(CoopGame)
gatelyValue(c(0,0,0,1,1,1,3.5))

\donttest{
library(CoopGame)
v=c(0,0,0,4,0,3,6)
gatelyValue(v)

#Output (18/11,36/11,12/11):
#1.636364 3.272727 1.090909

#Example from original paper by Gately (1974)
library(CoopGame)
v=c(0,0,0,1170,770,210,1530)
gatelyValue(v)

#Output:
#827.7049 476.5574 225.7377 
}

}
\references{
Gately D. (1974) "Sharing the Gains from Regional Cooperation. A Game Theoretic Application to Planning Investment in Electric Power", International Economic Review 15(1), pp. 195--208

Staudacher J. and Anwander J. (2019) "Conditions for the uniqueness of the Gately point for cooperative games", arXiv preprint, arXiv:1901.01485, 10 pages.

Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, pp. 455--456
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
