% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WebersetConcept.R
\name{drawWeberset}
\alias{drawWeberset}
\title{Draw Weber Set for 3 or 4 players}
\usage{
drawWeberset(v, holdOn = FALSE, colour = NA, label = FALSE,
  name = "Weber Set")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawWeberset draws the Weber Set for 3 or 4 players.
}
\examples{
library(CoopGame)
v = c(0,1,2,3,4,5,6)
drawWeberset(v, colour ="yellow")
}
\references{
Weber R.J. (1988) "Probabilistic values for games". In: Roth A.E. (Ed.), The Shapley Value. Essays in in honor of Lloyd S. Shapley, Cambridge University Press, pp. 101--119

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 327--329
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
