% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreCoverConcept.R
\name{drawCoreCover}
\alias{drawCoreCover}
\title{Draw core cover for 3 or 4 players}
\usage{
drawCoreCover(v, holdOn = FALSE, colour = NA, label = FALSE,
  name = "Core Cover")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCoreCover draws the core cover for 3 or 4 players.
}
\examples{
library(CoopGame)
v <- c(0,0,0,3,3,3,6)
drawCoreCover(v)
}
\references{
Tijs S.H. and Lipperts F.A.S. (1982) "The hypercube and the core cover of n-person cooperative games", Cahiers du Centre d' Etudes de Researche Operationelle 24, pp. 27--37

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 45--46
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
