% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSharingGame.R
\name{costSharingGameVector}
\alias{costSharingGameVector}
\title{Compute game vector for a cost sharing game}
\usage{
costSharingGameVector(n, Costs)
}
\arguments{
\item{n}{represents the number of players}

\item{Costs}{A vector containing the costs each coalition has to pay}
}
\value{
Game vector with cost-savings of each coalition S as compared to singleton coalitions.
}
\description{
\strong{Coalition vector for a cost sharing game:} \cr
For further information see \link{costSharingGame}
}
\examples{
library(CoopGame)
costSharingGameVector(n=3, Costs=c(2,2,2,3,3,3,4))

\donttest{
#Example with 3 students sharing an appartment:
#-------------------------------
#| costs     |  A  |  B  |  C  |
#- -----------------------------
#|single     | 300 | 270 | 280 |
#|appartment |     |     |     |
#-------------------------------
#
#Appartment for 2 persons => costs: 410
#Appartment for 3 persons => costs: 550

#Savings for all combinations sharing appartments
library(CoopGame)
(v=costSharingGameVector(n=3, Costs=c(300,270,280,410,410,410,550)))
#Output: 
#[1]   0   0   0 160 170 140 300
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 14--16

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 667--668
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
