% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidImputationSetConcept.R
\name{centroidImputationSet}
\alias{centroidImputationSet}
\title{Compute centroid of the imputation set}
\usage{
centroidImputationSet(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Calculates the centroid of the imputation set for a game specified by a game vector.
}
\description{
Calculates the centroid of the imputation set for specified game.
}
\examples{
library(CoopGame)
v=c(0,0,0,2,2,3,5)
centroidImputationSet(v) 

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 20

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 674

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, p. 278

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 407
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
