% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WebersetConcept.R
\name{belongsToWeberset}
\alias{belongsToWeberset}
\title{Check if point is element of Weber Set}
\usage{
belongsToWeberset(x, v)
}
\arguments{
\item{x}{numeric vector containing allocations for each player}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if point belongs to Weber Set and \code{FALSE} otherwise
}
\description{
belongsToWeberset checks if the point is in the Weber Set
}
\examples{
library(CoopGame)
belongsToWeberset(x=c(1,0.5,0.5), v=c(0,0,0,1,1,1,2))

\donttest{
library(CoopGame)
v=c(0,1,2,3,4,5,6)

#Point belongs to Weber Set:
belongsToWeberset(x=c(1.5,1,3.5),v)

#Point does not belong to Weber Set:
belongsToWeberset(x=c(2.05,2,2),v)
}

}
\references{
Weber R.J. (1988) "Probabilistic values for games". In: Roth A.E. (Ed.), The Shapley Value. Essays in in honor of Lloyd S. Shapley, Cambridge University Press, pp. 101--119

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 327--329
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}
}
