% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateHedgingPortfolio.R
\name{MultivariateHedgingPortfolio}
\alias{MultivariateHedgingPortfolio}
\title{Multivariate Hedging Portfolio}
\usage{
MultivariateHedgingPortfolio(
  x,
  H,
  method = c("cumsum", "cumprod"),
  statistics = c("Fisher", "Bartlett", "Fligner-Killeen", "Levene", "Brown-Forsythe"),
  metric = "StdDev",
  digit = 2
)
}
\arguments{
\item{x}{zoo return matrix (in percentage)}

\item{H}{Residual variance-covariance, correlation or pairwise connectedness matrix}

\item{method}{Cumulative sum or cumulative product}

\item{statistics}{Hedging effectiveness statistic}

\item{metric}{Risk measure of Sharpe Ratio (StdDev, VaR, or CVaR)}

\item{digit}{Number of decimal places}
}
\value{
Get hedge ratios
}
\description{
This function calculates the multivariate hedging portfolio of Cocca et al. (2024)
}
\examples{
\donttest{
data("g2020")
fit = VAR(g2020, configuration=list(nlag=1))
mhp = MultivariateHedgingPortfolio(g2020/100, fit$Q)
mhp$TABLE
}
}
\references{
Cocca, T., Gabauer, D., & Pomberger, S. (2024). Clean energy market connectedness and investment strategies: New evidence from DCC-GARCH R2 decomposed connectedness measures. Energy Economics.

Ederington, L. H. (1979). The hedging performance of the new futures markets. The Journal of Finance, 34(1), 157-170.

Antonakakis, N., Cunado, J., Filis, G., Gabauer, D., & de Gracia, F. P. (2020). Oil and asset classes implied volatilities: Investment strategies and hedging effectiveness. Energy Economics, 91, 104762.
}
\author{
David Gabauer
}
