% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElasticNetVAR.R
\name{ElasticNetVAR}
\alias{ElasticNetVAR}
\title{Elastic Net vector autoregression}
\usage{
ElasticNetVAR(
  x,
  configuration = list(nlag = 1, nfolds = 10, loss = "mae", alpha = NULL, n_alpha = 10)
)
}
\arguments{
\item{x}{zoo data matrix}

\item{configuration}{Model configuration}

\item{nlag}{Lag length}

\item{nfolds}{N-fold cross validation}

\item{loss}{Loss function}

\item{alpha}{LASSO is alpha equal 1 and Ridge if alpha equal 0}

\item{n_alpha}{Creates n-equidistant alpha values}
}
\value{
Estimate VAR model
}
\description{
Estimation of a VAR using equation-by-equation LASSO, Ridge or Elastic Net regressions.
}
\examples{
\donttest{
data("dy2012")
fit = ElasticNetVAR(dy2012, configuration=list(nlag=1, alpha=1, nfolds=10, loss="mae"))
}
}
\references{
Tibshirani, R., Bien, J., Friedman, J., Hastie, T., Simon, N., Taylor, J., & Tibshirani, R. J. (2012). Strong rules for discarding predictors in lasso‐type problems. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 74(2), 245-266.

Hoerl, A. E., & Kennard, R. W. (1970). Ridge regression: Biased estimation for nonorthogonal problems. Technometrics, 12(1), 55-67.

Zou, H., & Hastie, T. (2005). Regularization and variable selection via the elastic net. Journal of the royal statistical society: series B (statistical methodology), 67(2), 301-320.

Demirer, M., Diebold, F. X., Liu, L., & Yilmaz, K. (2018). Estimating global bank network connectedness. Journal of Applied Econometrics, 33(1), 1-15.

Gabauer, D., Gupta, R., Marfatia, H., & Miller, S. M. (2020). Estimating US Housing Price Network Connectedness: Evidence from Dynamic Elastic Net, Lasso, and Ridge Vector Autoregressive Models. Lasso, and Ridge Vector Autoregressive Models (July 26, 2020).
}
\author{
David Gabauer
}
