% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VFEVD.R
\name{VFEVD}
\alias{VFEVD}
\title{Generalized volatility forecast error variance decomposition and volatility impulse response functions}
\usage{
VFEVD(fit, nfore = 100, standardize = FALSE)
}
\arguments{
\item{fit}{Fitted DCC-GARCH model}

\item{nfore}{H-step ahead forecast horizon}

\item{standardize}{Boolean value whether GIRF should be standardized}
}
\value{
Get volatility impulse response functions and forecast error variance decomposition
}
\description{
This function provides the volatility impulse responses and the forecast error variance decomposition of DCC-GARCH models.
}
\examples{
\donttest{
data("g2020")
ugarch.spec = ugarchspec(mean.model=list(armaOrder=c(0,0)),
                         variance.model=list(garchOrder=c(1,1), model="sGARCH"),
                         distribution.model="norm")
mgarch.spec = dccspec(uspec=multispec(replicate(ncol(g2020), ugarch.spec)),
                      dccOrder=c(1,1), distribution="mvnorm")
fit = dccfit(mgarch.spec, data=g2020)
fevd = VFEVD(fit, nfore=100, standardize=FALSE)
}
}
\references{
Engle, R. (2002). Dynamic conditional correlation: A simple class of multivariate generalized autoregressive conditional heteroskedasticity models. Journal of Business & Economic Statistics, 20(3), 339-350.\\
Gabauer, D. (2020). Volatility impulse response analysis for DCC‐GARCH models: The role of volatility transmission mechanisms. Journal of Forecasting, 39(5), 788-796.
}
\author{
David Gabauer
}
