/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.mouse;

import java.awt.event.MouseEvent;
import java.io.Serializable;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.action.CloseWithAbortWindowAction;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.gui.mouse.MouseButtonListener;

public class DockingWindowActionMouseButtonListener
implements MouseButtonListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MODIFIER_MASK = 960;
    public static final MouseButtonListener MIDDLE_BUTTON_CLOSE_LISTENER = new DockingWindowActionMouseButtonListener(2, CloseWithAbortWindowAction.INSTANCE);
    private int eventId;
    private int button;
    private int keyMask;
    private DockingWindowAction action;
    private boolean consumeEvent;

    public DockingWindowActionMouseButtonListener(int n, DockingWindowAction dockingWindowAction) {
        this(500, n, dockingWindowAction);
    }

    public DockingWindowActionMouseButtonListener(int n, int n2, DockingWindowAction dockingWindowAction) {
        this(n, n2, 0, dockingWindowAction, false);
    }

    public DockingWindowActionMouseButtonListener(int n, int n2, int n3, DockingWindowAction dockingWindowAction, boolean bl) {
        this.eventId = n;
        this.button = n2;
        this.keyMask = n3;
        this.action = dockingWindowAction;
        this.consumeEvent = bl;
    }

    public void mouseButtonEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getModifiersEx() & 0x3C0;
        if (mouseEvent.getButton() == 2) {
            n &= 0xFFFFFDFF;
        }
        if (mouseEvent.getButton() == 3) {
            n &= 0xFFFFFEFF;
        }
        if (mouseEvent.getID() == this.eventId && mouseEvent.getButton() == this.button && n == this.keyMask) {
            DockingWindow dockingWindow = (DockingWindow)mouseEvent.getSource();
            this.action.perform(dockingWindow);
            if (this.consumeEvent) {
                mouseEvent.consume();
            }
        }
    }
}

