/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUI;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUIListener;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;

public class LookAndFeelTheme
extends TabbedPanelTitledTabTheme {
    private static TabbedPanelProperties tpProps = new TabbedPanelProperties();
    private static TitledTabProperties tabProps = new TitledTabProperties();
    private TabbedPanelProperties themeTpProps = new TabbedPanelProperties();
    private TitledTabProperties themeTabProps = new TitledTabProperties();
    private static int themeCounter = 0;
    private static PaneUI ui;
    private boolean disposed = false;

    public LookAndFeelTheme() {
        if (themeCounter == 0) {
            ui = new PaneUI(new PaneUIListener(){

                public void updating() {
                }

                public void updated() {
                    LookAndFeelTheme.this.initTheme();
                }
            });
            ui.init();
        }
        ++themeCounter;
        this.themeTpProps.addSuperObject(tpProps);
        this.themeTabProps.addSuperObject(tabProps);
    }

    public String getName() {
        return "Look and Feel Theme";
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.themeTpProps;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.themeTabProps;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (--themeCounter == 0) {
                ui.dispose();
                PropertyMapManager.runBatch(new Runnable(){

                    public void run() {
                        tpProps.getMap().clear(true);
                        tabProps.getMap().clear(true);
                    }
                });
            }
        }
    }

    private void initTheme() {
        PropertyMapManager.runBatch(new Runnable(){

            public void run() {
                tpProps.getMap().clear(true);
                tabProps.getMap().clear(true);
                tpProps.setShadowEnabled(false).setTabSpacing(ui.getTabSpacing()).setTabScrollingOffset(ui.getScrollOffset()).setEnsureSelectedTabVisible(true);
                tpProps.getTabAreaComponentsProperties().getComponentProperties().setBorder(null).setInsets(InsetsUtil.EMPTY_INSETS);
                tpProps.getTabAreaProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(new Border(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public Insets getBorderInsets(Component component) {
                        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
                        return tabbedPanel.isTabAreaVisible() ? LookAndFeelTheme.access$300().getTabAreaInsets(tabbedPanel.getProperties().getTabAreaOrientation()) : InsetsUtil.EMPTY_INSETS;
                    }

                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
                tpProps.getTabAreaComponentsProperties().getShapedPanelProperties().setOpaque(ui.isTabAreaComponentsOpaque());
                tpProps.getTabAreaProperties().getShapedPanelProperties().setOpaque(ui.isTabAreaOpaque()).setComponentPainter(new ComponentPainter(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
                        LookAndFeelTheme.access$300().paintTabArea(TabbedUtils.getParentTabbedPanel(component), graphics, n, n2, n3, n4);
                    }

                    public boolean isOpaque(Component component) {
                        return false;
                    }

                    public Color getColor(Component component) {
                        return null;
                    }
                });
                tpProps.getContentPanelProperties().getShapedPanelProperties().setOpaque(ui.isContentOpaque()).setComponentPainter(new ComponentPainter(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
                        TabbedPanelContentPanel tabbedPanelContentPanel = TabbedUtils.getParentTabbedPanelContentPanel(component);
                        LookAndFeelTheme.access$300().paintContentArea(tabbedPanelContentPanel, graphics, n, n2, n3, n4);
                    }

                    public boolean isOpaque(Component component) {
                        return false;
                    }

                    public Color getColor(Component component) {
                        return null;
                    }
                });
                tpProps.getContentPanelProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(new Border(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public Insets getBorderInsets(Component component) {
                        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanelContentPanel(component).getTabbedPanel();
                        return LookAndFeelTheme.access$300().getContentInsets(tabbedPanel.getProperties().getTabAreaOrientation(), tabbedPanel.isTabAreaVisible());
                    }

                    public boolean isBorderOpaque() {
                        return false;
                    }
                });
                tabProps.setSizePolicy(TitledTabSizePolicy.INDIVIDUAL_SIZE).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE).setHighlightedRaised(ui.getSelectedRaised(Direction.UP)).setFocusMarkerEnabled(false);
                tabProps.getNormalProperties().setIconTextGap(ui.getTextIconGap()).setTextTitleComponentGap(ui.getTextIconGap());
                tabProps.getNormalProperties().getComponentProperties().setInsets(InsetsUtil.EMPTY_INSETS).setBorder(LookAndFeelTheme.this.createTabInsetsBorder(false)).setFont(ui.getFont());
                tabProps.getHighlightedProperties().getComponentProperties().setBorder(LookAndFeelTheme.this.createTabInsetsBorder(true));
                tabProps.getDisabledProperties().getComponentProperties().setBorder(LookAndFeelTheme.this.createTabInsetsBorder(false));
                tabProps.getNormalProperties().getShapedPanelProperties().setOpaque(false).setComponentPainter(null);
                tabProps.setMinimumSizeProvider(new DimensionProvider(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Dimension getDimension(Component component) {
                        return LookAndFeelTheme.access$300().getTabExternalMinSize(TabbedUtils.getParentTab(component).getTabbedPanel().getProperties().getTabAreaOrientation());
                    }
                });
                tabProps.setHoverListener(new HoverListener(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void mouseEntered(HoverEvent hoverEvent) {
                        LookAndFeelTheme.access$300().setHoveredTab((Tab)hoverEvent.getSource());
                    }

                    public void mouseExited(HoverEvent hoverEvent) {
                        LookAndFeelTheme.access$300().setHoveredTab(null);
                    }
                });
            }
        });
    }

    private Border createTabInsetsBorder(final boolean bl) {
        return new Border(){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            }

            public Insets getBorderInsets(Component component) {
                TitledTab titledTab = (TitledTab)TabbedUtils.getParentTab(component);
                if (titledTab.getTabbedPanel() == null) {
                    return new Insets(0, 0, 0, 0);
                }
                Direction direction = titledTab.getTabbedPanel().getProperties().getTabAreaOrientation();
                Direction direction2 = bl ? titledTab.getProperties().getHighlightedProperties().getDirection() : titledTab.getProperties().getNormalProperties().getDirection();
                return bl ? ui.getSelectedTabInsets(direction, direction2) : ui.getNormalTabInsets(direction, direction2);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    public Color getBorderColor(Direction direction) {
        return ui.getContentTabAreaBorderColor(direction);
    }
}

