/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class BaseContainer
extends JPanel {
    private Color foreground;
    private Color background;
    private Font font;
    private Color overridedBackground;
    private Color overridedForeground;
    private Font overridedFont;
    private boolean forcedOpaque = true;
    private boolean opaque = true;
    private static PanelUI UI = new PanelUI(){};

    public BaseContainer() {
        this(true);
    }

    public BaseContainer(boolean bl) {
        this(bl, new BorderLayout());
    }

    public BaseContainer(LayoutManager layoutManager) {
        this(true, layoutManager);
    }

    public BaseContainer(boolean bl, LayoutManager layoutManager) {
        super(layoutManager);
        this.forcedOpaque = bl;
        this.updateOpaque();
    }

    public void setUI(PanelUI panelUI) {
        Color color = this.overridedBackground;
        Color color2 = this.overridedForeground;
        Font font = this.overridedFont;
        color = null;
        color2 = null;
        font = null;
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        super.setUI(panelUI);
        this.background = this.getBackground();
        this.foreground = this.getForeground();
        this.font = this.getFont();
        this.overridedBackground = color;
        this.overridedForeground = color2;
        this.overridedFont = font;
        if (!this.forcedOpaque) {
            super.setUI(UI);
        }
        this.updateBackground();
        this.updateForeground();
        this.updateFont();
    }

    void setForcedOpaque(boolean bl) {
        if (this.forcedOpaque != bl) {
            this.forcedOpaque = bl;
            this.updateUI();
            this.updateOpaque();
        }
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
        this.updateOpaque();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.forcedOpaque) {
            super.paintComponent(graphics);
        }
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.updateForeground();
    }

    public void setBackground(Color color) {
        this.background = color;
        this.updateBackground();
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateFont();
    }

    void setOverridedForeround(Color color) {
        this.overridedForeground = color;
        this.updateForeground();
    }

    void setOverridedBackground(Color color) {
        this.overridedBackground = color;
        this.updateBackground();
    }

    void setOverrideFont(Font font) {
        this.overridedFont = font;
        this.updateFont();
    }

    private void updateBackground() {
        super.setBackground(this.overridedBackground == null ? this.background : this.overridedBackground);
    }

    private void updateForeground() {
        super.setForeground(this.overridedForeground == null ? this.foreground : this.overridedForeground);
    }

    private void updateFont() {
        super.setFont(this.overridedFont == null ? this.font : this.overridedFont);
    }

    private void updateOpaque() {
        super.setOpaque(this.forcedOpaque ? this.opaque : this.forcedOpaque);
    }
}

