% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzPlot.R
\name{fuzzPlot}
\alias{fuzzPlot}
\title{Visualize fuzzy clustering results}
\usage{
fuzzPlot(Tc, clustObj, mfrow = c(1, 1), cols, min.mem = 0,
  new.window = FALSE, llwd = 3)
}
\arguments{
\item{Tc}{a numeric matrix to be clustered. The columns correspond to the time-course and the rows correspond to phosphorylation sites.}

\item{clustObj}{the clustering of Tc generated from cmeans or kmeans clustering.}

\item{mfrow}{control the subplots in graphic window.}

\item{cols}{color palette to be used for plotting. If the color argument remains empty, the default palette is used.}

\item{min.mem}{phosphorylation sites with membership values below min.mem will not be displayed.}

\item{new.window}{should a new window be opened for graphics.}

\item{llwd}{line width. Default is 3.}
}
\description{
Takes in a time-course matrix and its clustering results as a cmeans clustering object. Produce a plot to visualize the clustering results.
}
\examples{
## load the human ES phosphoprotoemics data (Rigbolt et al. Sci Signal. 4(164):rs3, 2011)
## (not run)
# data(hES)

## apply cmeans clustering to partition the data into 11 clusters
# library(e1071)
# clustObj <- cmeans(hES, centers=11, iter.max=10, m=1.25)
## visualize clustering reuslts
# fuzzPlot(hES, clustObj, mfrow = c(3,4))

}
