% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarycpAlgorithm.R
\name{summary.cpAlgorithm}
\alias{summary.cpAlgorithm}
\title{summary.cpAlgorithm}
\usage{
\method{summary}{cpAlgorithm}(
  object,
  details = c("communities.labels", "shared.nodes.labels", "isolated.nodes.labels"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{cpAlgorithm}; see also
\link{cpAlgorithm}}

\item{details}{A string or vector indicating about which part of
the results more information is requested; default is
\code{c("communities.labels","shared.nodes.labels","isolated.nodes.labels")};
see Details}

\item{...}{currently ignored}
}
\value{
Prints information depending on \code{details}.
}
\description{
Summary method for objects of class \code{cpAlgorithm}.
}
\details{
The function extracts information from an object produced by \code{cpAlgorithm}.
  To do so, the user has to specify in \code{details} which information is requested.
  It is possible to extract information about the communities with either
  numbers (\code{communities.numbers}) or labels (\code{communities.labels})
  as identifiers of the nodes. Moreover, it is possible to extract information about
  shared nodes with either numbers (\code{shared.nodes.numbers}) or labels
  (\code{shared.nodes.labels}) as identifiers of the nodes. Finally, it is possible
  to extract information about isolated nodes with either numbers
  (\code{isolated.nodes.numbers}) or labels (\code{isolated.nodes.labels})
  as identifiers of the nodes. Any combination of these options can be specified
  in \code{details}.
}
\examples{
## Example for unweighted networks

# create qgraph object
W <- matrix(c(0,1,1,1,0,0,0,0,
              0,0,1,1,0,0,0,0,
              0,0,0,0,0,0,0,0,
              0,0,0,0,1,1,1,0,
              0,0,0,0,0,1,1,0,
              0,0,0,0,0,0,1,0,
              0,0,0,0,0,0,0,1,
              0,0,0,0,0,0,0,0), nrow = 8, ncol = 8, byrow = TRUE)
colnames(W) <- letters[1:8]
rownames(W) <- letters[1:8]
W <- Matrix::forceSymmetric(W)
W <- qgraph::qgraph(W)

# run clique percolation for unweighted networks
results <- cpAlgorithm(W = W, k = 3, method = "unweighted")

# print results overview
results

# extract details about the communities
summary(results, details = "communities.labels")

# extract information about shared and isolated nodes
summary(results, details = c("shared.nodes.numbers", "isolated.nodes.labels"))

}
\author{
Jens Lange, \email{lange.jens@outlook.com}
}
