% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeasonSelect.R
\name{SeasonSelect}
\alias{SeasonSelect}
\title{Selects a season from daily data for multidimensional arrays}
\usage{
SeasonSelect(data, season, dates = NULL, timedim = NULL, calendar = NULL)
}
\arguments{
\item{data}{A numeric multidimensional array containing daily data.}

\item{season}{A charcater string indicating the season by the three months initials in capitals: 'DJF' for winter (summer), 'MAM' spring (autumn), 'JJA' for summer (winter) or 'SON' for autumn (spring) in the northern (southern) hemisphere.}

\item{dates}{A vector of dates with a calendar attributes. If NULL (by default), the 'time' attributes of parameter 'data' are considered.}

\item{timedim}{An integer number indicating the position of the time dimension in the parameter \code{data}. If NULL (by default), the dimension called 'time' in parameter \code{data}.}

\item{calendar}{A character indicating the calendar type.}
}
\value{
A list of length 2:
\itemize{
\item\code{$data} {A vector or array containing the daily values for the selected season, with the same dimensions as \code{data} input but the 'time' dimension reduce to the number of days corresponding to the selected season.}
\item\code{$dates} {A vector of dates reduce to the number of days corresponding to the selected season.}}
}
\description{
This function selects the daily data corresponding to the specified season.
}
\examples{
## Example with synthetic data:
data <- 1:(2 * 3 * (366 + 365) * 2)
dim(data) <- c(lon = 2, lat = 3, time = 366 + 365, model = 2)
time <- seq(ISOdate(1903,1,1), ISOdate(1904,12,31), "days")
time <- as.POSIXct(time, tz = "CET")
metadata <- list(time = list(standard_name = 'time', long_name = 'time', 
                            calendar = 'noleap',
                            units = 'days since 1970-01-01 00:00:00', prec = 'double', 
                            dim = list(list(name ='time', unlim = FALSE))))
attr(time, "variables") <- metadata
attr(data, 'Variables')$dat1$time <- time
attr(data, 'Variables')$dat2$time <- time
attr(data, 'Variables')$common[[2]]$dim[[3]]$len = length(time)
attr(data, 'Variables')$common[[2]]$dim[[3]]$vals <- time

a <- SeasonSelect(data = data, season = 'JJA')
str(a)
}

