% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rvm}
\alias{rvm}
\title{Generate random deviates for the von Mises distribution}
\usage{
rvm(n, mu, k)
}
\arguments{
\item{n}{number of observations.}

\item{mu}{mean direction of the distribution.}

\item{k}{non-negative numeric value for the concentration parameter of the
distribution}
}
\value{
a vector
}
\description{
Generate random deviates for the von Mises distribution.
}
\details{
A random variable for circular normal distribution has the form:\cr
\deqn{f(theta; mu, kappa) = 1 / (2 * pi * I0(kappa)) * exp(kappa * cos(theta-mu))}
theta is withins 0 and 2 * pi.

\code{I0(kappa)} in the normalizing constant is the modified Bessel
function of the first kind and order zero.
}
\examples{
n  <- 100
mu <- 0
k  <- 10
vm3_de <- rvm(n, mu, k)       ## in degree unit
vm3_pi <- vm3_de \%\% (2 * pi)  ## in radian unit
}
