% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cardio_diabetes_tbl_df}
\alias{cardio_diabetes_tbl_df}
\title{Cardiovascular risks of diabetes drugs}
\format{
A tibble with 227,571 observations and 2 variables:
\describe{
  \item{treatment}{Type of diabetes medication (factor with 2 levels: Rosiglitazone or Pioglitazone)}
  \item{cardiovascular_problems}{Presence of cardiovascular problems (factor with 2 levels)}
}
}
\source{
Data taken from the openintro package version 2.5.0. Original study:
Graham DJ, et al. (2010). "Risk of acute myocardial infarction, stroke, heart failure,
and death in elderly Medicare patients treated with rosiglitazone or pioglitazone."
JAMA, 304(4):411.
}
\usage{
data(cardio_diabetes_tbl_df)
}
\description{
This dataset, cardio_diabetes_tbl_df, is a tibble containing information comparing
cardiovascular problems between two diabetes medications (Rosiglitazone and Pioglitazone)
in elderly Medicare patients. It includes data from 227,571 patients.
}
\details{
The dataset name has been kept as 'cardio_diabetes_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
