% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myfunctions.R
\name{SparseCCA}
\alias{SparseCCA}
\title{Sparse canonical correlation analysis.}
\usage{
SparseCCA(X1, X2, rank = 2, penaltyx1 = NULL, penaltyx2 = NULL, 
             nperms = 25, ifplot = 0)
}
\arguments{
\item{X1, X2}{Numeric matrices representing the two sets of covariates. They should have the same number of rows and 
cannot contain missing values.}

\item{rank}{The number of canonical variate pairs wanted. The default is 2.}

\item{penaltyx1, penaltyx2}{Numeric vectors as the penalties to be applied to X1 and X2. The defaults are seq(0.1, 0.7, len = 20).
See PMA package for details.}

\item{nperms}{Number of times the data should be permuted. The default is 25. Don't use too small value. See PMA package for details.}

\item{ifplot}{0 or 1.  The default is 0 which means don't plot the result. See PMA package for details.}
}
\value{
\item{W1}{Loading matrix corresponding to X1. X1*W1 gives the canonical variates from X1.}

\item{W2}{Loading matrix corresponding to X2. X2*W2 gives the canonical variates from X2.}
}
\description{
Get sparse CCA solutions of X1 and X2. Use \code{CCA} and \code{CCA.permute} from PMA package. 
               See PMA package for details.
}
\details{
This function is generally used for tuning the penalties in sparse CCA if \code{penaltyx1} and \code{penaltyx2} are supplied as vectors.
         The CCA solution is based on PMD algorithm and the tuning is based on permutation.
         The fitted  W1 and W2 are scaled so that the diagonals of W1'X1'X1W1 and W2'X2'X2W2 are all 1's.
         
         Specifically, if a single value of mild penalty is provided for both \code{penaltyx1} and \code{penaltyx2}, the result can be used as 
         initial values of W's in CVR. For instance, with \code{penaltyx1 = 0.7} and \code{penaltyx2 = 0.7},  
         the fitted W1 and W2 are only shrinked, but mostly not zero yet.
}
\references{
Daniela M. Witten,  Robert Tibshirani and Trevor Hastie (2009) A penalized matrix decomposition, with applications to 
               sparse principal components and canonical correlation analysis. Biostatistics 10(3), 515-534.
             
     Chongliang Luo, Jin Liu, Dipak D. Dey and Kun Chen (2016) Canonical variate regression. 
       Biostatistics, doi: 10.1093/biostatistics/kxw001.
}
\seealso{
\code{\link{CVR}}, \code{\link{CCA}}, \code{\link{CCA.permute}}.
}
\author{
Chongliang Luo, Kun Chen.
}
