library(CRF)

nNodes <- 60
nStates <- 7

adj <- matrix(0, nrow=nNodes, ncol=nNodes)
for (i in 1:(nNodes-1))
{
	adj[i,i+1] <- 1
	adj[i+1,i] <- 1
}

crf <- make.crf(adj, nStates)

crf$node.pot[1,] <- c(.3, .6, .1, 0, 0, 0, 0)
crf$node.pot[-1,] <- 1

for (i in 1:crf$n.edges)
{
	crf$edge.pot[[i]][1,] <- c(.08, .9, .01, 0, 0, 0, .01)
	crf$edge.pot[[i]][2,] <- c(.03, .95, .01, 0, 0, 0, .01)
	crf$edge.pot[[i]][3,] <- c(.06, .06, .75, .05, .05, .02, .01)
	crf$edge.pot[[i]][4,] <- c(0, 0, 0, .3, .6, .09, .01)
	crf$edge.pot[[i]][5,] <- c(0, 0, 0, .02, .95, .02, .01)
	crf$edge.pot[[i]][6,] <- c(0, 0, 0, .01, .01, .97, .01)
	crf$edge.pot[[i]][7,] <- c(0, 0, 0, 0, 0, 0, 1)
}

answer <-
structure(list(decode = c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
2L, 2L, 2L), node.bel = structure(c(0.3, 0.048, 0.03426, 0.0326154, 
0.031713054, 0.0309518229, 0.0302766855918, 0.029666271979794, 
0.0291056213152808, 0.0285836146305379, 0.0280919483963713, 0.0276244143101683, 
0.0271763650233506, 0.026744316269596, 0.0263256504922663, 0.0259183960729913, 
0.0255210628750498, 0.0251325197354752, 0.0247519032046606, 0.0243785495621711, 
0.024011944170976, 0.0236516837470674, 0.0232974482497644, 0.0229489799384943, 
0.0226060677679181, 0.0222685357596311, 0.0219362343360636, 0.0216090338609727, 
0.0212868198236793, 0.0209694892477834, 0.0206569480120494, 0.020349108850822, 
0.0200458898606803, 0.0197472133842436, 0.0194530051749743, 0.0191631937713476, 
0.0188777100270352, 0.018596486757356, 0.0183194584723874, 0.0180465611746825, 
0.0177777322051628, 0.0175129101249496, 0.0172520346240143, 0.0169950464498568, 
0.0167418873511506, 0.0164925000325855, 0.0162468281180987, 0.0160048161203995, 
0.0157664094152303, 0.0155315542191992, 0.0153001975703187, 0.015072287310603, 
0.0148477720702433, 0.0146266012530004, 0.0144087250225462, 0.0141940942895532, 
0.0139826606993826, 0.0137743766202578, 0.013569195131839, 0.0133670700141364, 
0.6, 0.846, 0.85194, 0.8444934, 0.83539161, 0.82551680838, 0.8151326440794, 
0.804415186718118, 0.79349393611938, 0.782464645338898, 0.771397986105198, 
0.760345959211975, 0.749346667232705, 0.738427869442832, 0.727609629720741, 
0.716906288819731, 0.706327933369055, 0.695881489992547, 0.685571540180893, 
0.675400927156415, 0.665371207795858, 0.655482989139457, 0.64573617893066, 
0.636130172119508, 0.62666398966743, 0.61733638182336, 0.608145904936452, 
0.599090978558081, 0.590169927863111, 0.581381015137263, 0.572722463121514, 
0.564192472292495, 0.55578923362745, 0.547510938007255, 0.539355783116729, 
0.531321978482217, 0.52340774912318, 0.51561133817285, 0.507931008732442, 
0.500365045155887, 0.492911753911818, 0.485569464132056, 0.478336527927964, 
0.471211320535276, 0.464192240332487, 0.457277708766417, 0.450466170209922, 
0.443756091770369, 0.437145963062697, 0.43063429595737, 0.424219624310842, 
0.417900503684239, 0.411675511054438, 0.405543244520683, 0.399502323009034, 
0.393551385976353, 0.387689093115061, 0.381914124059608, 0.376225178095289, 
0.370620973869911, 0.1, 0.0840000000000001, 0.0719400000000001, 
0.0628170000000001, 0.0558838380000001, 0.05058392514, 0.0465026301678, 
0.043331065922562, 0.0408391140289007, 0.0388553310960221, 0.037251980921711, 
0.0359338850362989, 0.0348301175124456, 0.0338878184568948, 0.0330675856997954, 
0.0323400420769766, 0.0316832784066597, 0.0310809487674359, 0.0305208516728571, 
0.0299938731884984, 0.0294931996585597, 0.0290137312635881, 0.0285516451765563, 
0.0281040701542215, 0.0276688441362461, 0.0272443336765381, 0.0268292994332335, 
0.0264227959676503, 0.0260240970999283, 0.0256326403018141, 0.0252479852702111, 
0.0248697830639939, 0.0244977531094286, 0.0241316660669528, 0.0237713310641296, 
0.0234165861810142, 0.0230672913582963, 0.0227233231102244, 0.0223845705819704, 
0.0220509326085261, 0.0217223155197003, 0.021398631500945, 0.0210797973682788, 
0.0207657336517289, 0.020456363908648, 0.0201516142083224, 0.0198514127442318, 
0.0195556895414541, 0.0192643762349983, 0.018977405901028, 0.0186947129275367, 
0.0184162329144641, 0.0181419025957965, 0.0178716597780942, 0.0176054432913075, 
0.0173431929487964, 0.0170848495142564, 0.0168303546738367, 0.0165796510121762, 
0.0163326819914034, 0, 0.00500000000000002, 0.00582000000000002, 
0.00562410000000002, 0.00526059300000002, 0.00493738764000002, 
0.00469020954450002, 0.00451219865178302, 0.00438885051943891, 
0.00430673286760422, 0.00425511329668935, 0.00422580444042451, 
0.00421266435730785, 0.00421111639612555, 0.00421776121583995, 
0.00423007927282668, 0.0042462068290741, 0.00426476844854717, 
0.00428475205481553, 0.00430541582760666, 0.00432621885341639, 
0.00434676948032557, 0.00436678686282406, 0.00438607233190072, 
0.00440448808344503, 0.00442194131740439, 0.00443837243654894, 
0.00445374626860172, 0.00446804553986919, 0.00448126602544112, 
0.00449341294772357, 0.00450449830434006, 0.00451453888783023, 
0.00452355482020445, 0.00453156847057385, 0.00453860365771472, 
0.00454468506448258, 0.00454983780965492, 0.00455408713668308, 
0.00455745818918776, 0.00455997585074477, 0.00456166463225119, 
0.00456254859443995, 0.0045626512962965, 0.00456199576250331, 
0.0045606044648048, 0.00455849931350009, 0.00455570165625019, 
0.00455223228211485, 0.00454811142927677, 0.00454335879531399, 
0.00453799354918152, 0.00453203434428612, 0.00452549933220394, 
0.00451840617671347, 0.00451077206790791, 0.00450261373621797, 
0.00449394746622674, 0.00448478911019466, 0.00447515410123997, 
0, 0.00500000000000002, 0.0119700000000001, 0.0185022000000001, 
0.0241548690000001, 0.0289795937100001, 0.0331224479868001, 0.0367231381428571, 
0.0398950285878309, 0.0427257646101187, 0.045282094244381, 0.0476146860767056, 
0.0497620637407714, 0.0517536349822353, 0.0536119766681565, 0.0553545459389642, 
0.0569949583341588, 0.0585439417480371, 0.0600100484150542, 0.0614001864700517, 
0.0627200170188465, 0.0639742509638777, 0.065166871103328, 0.066301298516843, 
0.0673805174036792, 0.0684071689278596, 0.0693836219346797, 0.0703120263988185, 
0.0711943539713509, 0.0720324288807582, 0.072827951614461, 0.0735825171901059, 
0.0742976293659307, 0.074974711796869, 0.0756151168877234, 0.0762201329044696, 
0.0767909897629537, 0.0773288638085467, 0.077834881821528, 0.0783101244242137, 
0.0787556290220198, 0.079172392377953, 0.0795613728956116, 0.0799234926675473, 
0.0802596393322113, 0.0805706677725122, 0.0808574016813779, 0.0811206350139817, 
0.0813611333419928, 0.0815796351219645, 0.081776852887524, 0.0819534743731731, 
0.0821101635760915, 0.0822475617612549, 0.0823662884143417, 0.0824669421462597, 
0.0825501015526119, 0.0826163260310211, 0.0826661565589123, 0.0827001164340868, 
0, 0.00200000000000001, 0.00417000000000002, 0.00624690000000002, 
0.00819204600000003, 0.01002051213, 0.0117555320307, 0.013417486491876, 
0.0150221438570886, 0.0165811589404601, 0.0181029520444535, 0.0195935051831438, 
0.0210569938495478, 0.0224962674512834, 0.0239132089721788, 0.025309002459798, 
0.0266843312808773, 0.028039524691884, 0.0293746659218062, 0.0306896716308437, 
0.031984350099574, 0.0332584436269424, 0.0345116592159127, 0.0357436905826872, 
0.0369542337484989, 0.0381429978943525, 0.0393097127281763, 0.0404541332929787, 
0.0415760429056928, 0.0426752547385358, 0.0437516124223209, 0.0448049899526399, 
0.0458352911065333, 0.0468424485227492, 0.0478264225581615, 0.0487872000028054, 
0.0497247927136252, 0.0506392362104449, 0.0515305882653759, 0.0523989275077861, 
0.0532443520602342, 0.0540669782158286, 0.0548669391638343, 0.0556443837676967, 
0.056399475397718, 0.0571323908192289, 0.0578433191361012, 0.0585324607887453, 
0.0592000266052542, 0.0598462369040267, 0.0604713206460007, 0.0610755146345001, 
0.0616590627606442, 0.0622222152922484, 0.0627652282041663, 0.0632883625480585, 
0.0637918838596295, 0.0642760616014376, 0.064741168639452, 0.0651874807516078, 
0, 0.0100000000000001, 0.0199000000000001, 0.0297010000000001, 
0.0394039900000002, 0.0490099501000002, 0.0585198505990002, 0.0679346520930103, 
0.0772553055720802, 0.0864827525163595, 0.095617924991196, 0.104661745741284, 
0.113615128283871, 0.122478977001032, 0.131254187231022, 0.139941645358712, 
0.148542228905125, 0.157056806616074, 0.165486238549913, 0.173831376164414, 
0.18209306240277, 0.190272131778742, 0.198369410460955, 0.206385716356345, 
0.214321859192782, 0.222178640600854, 0.229956854194845, 0.237657285652897, 
0.245280712796368, 0.252827905668405, 0.260299626611721, 0.267696630345603, 
0.275019664042147, 0.282269467401726, 0.289446772727708, 0.296552305000432, 
0.303586781950427, 0.310550914130923, 0.317445404989613, 0.324270950939717, 
0.33102824143032, 0.337717959016017, 0.344340779425857, 0.350897371631598, 
0.357388397915282, 0.363814513936129, 0.370176368796768, 0.3764746051088, 
0.382709859057712, 0.388882760467135, 0.394993932862464, 0.401043993533839, 
0.407033553598501, 0.412963218062516, 0.418833585881891, 0.424645250023072, 
0.430398797522841, 0.436094809547612, 0.441733861452136, 0.447316522837615
), .Dim = c(60L, 7L)), edge.bel = list(structure(c(0.024, 0.018, 
0.006, 0, 0, 0, 0, 0.27, 0.57, 0.006, 0, 0, 0, 0, 0.003, 0.00600000000000001, 
0.0750000000000001, 0, 0, 0, 0, 0, 0, 0.00500000000000002, 0, 
0, 0, 0, 0, 0, 0.00500000000000002, 0, 0, 0, 0, 0, 0, 0.00200000000000001, 
0, 0, 0, 0, 0.00300000000000001, 0.00600000000000003, 0.001, 
0, 0, 0, 0), .Dim = c(7L, 7L)), structure(c(0.00384, 0.02538, 
0.00504, 0, 0, 0, 0, 0.0432, 0.8037, 0.00504, 0, 0, 0, 0, 0.000480000000000001, 
0.00846000000000001, 0.0630000000000001, 0, 0, 0, 0, 0, 0, 0.00420000000000002, 
0.00150000000000001, 1e-04, 2.00000000000001e-05, 0, 0, 0, 0.00420000000000002, 
0.00300000000000001, 0.00475000000000002, 2.00000000000001e-05, 
0, 0, 0, 0.00168000000000001, 0.000450000000000002, 1e-04, 0.00194000000000001, 
0, 0.000480000000000002, 0.00846000000000004, 0.000840000000000004, 
5.00000000000003e-05, 5.00000000000003e-05, 2.00000000000001e-05, 
0.0100000000000001), .Dim = c(7L, 7L)), structure(c(0.0027408, 
0.0255582, 0.0043164, 0, 0, 0, 0, 0.030834, 0.809343, 0.0043164, 
0, 0, 0, 0, 0.0003426, 0.00851940000000001, 0.0539550000000001, 
0, 0, 0, 0, 0, 0, 0.00359700000000001, 0.00174600000000001, 0.000239400000000001, 
4.17000000000002e-05, 0, 0, 0, 0.00359700000000001, 0.00349200000000001, 
0.0113715, 4.17000000000002e-05, 0, 0, 0, 0.00143880000000001, 
0.000523800000000002, 0.000239400000000001, 0.00404490000000002, 
0, 0.000342600000000001, 0.00851940000000004, 0.000719400000000003, 
5.82000000000002e-05, 0.0001197, 4.17000000000002e-05, 0.0199000000000001
), .Dim = c(7L, 7L)), structure(c(0.002609232, 0.025334802, 0.00376902, 
0, 0, 0, 0, 0.02935386, 0.80226873, 0.00376902, 0, 0, 0, 0, 0.000326154, 
0.00844493400000001, 0.04711275, 0, 0, 0, 0, 0, 0, 0.00314085000000001, 
0.00168723000000001, 0.000370044000000001, 6.24690000000002e-05, 
0, 0, 0, 0.00314085000000001, 0.00337446000000001, 0.0175770900000001, 
6.24690000000002e-05, 0, 0, 0, 0.00125634, 0.000506169000000002, 
0.000370044000000001, 0.00605949300000002, 0, 0.000326154000000001, 
0.00844493400000003, 0.000628170000000003, 5.62410000000002e-05, 
0.000185022000000001, 6.24690000000003e-05, 0.0297010000000001
), .Dim = c(7L, 7L)), structure(c(0.00253704432, 0.0250617483, 
0.00335303028, 0, 0, 0, 0, 0.0285417486, 0.7936220295, 0.00335303028, 
0, 0, 0, 0, 0.00031713054, 0.0083539161, 0.0419128785, 0, 0, 
0, 0, 0, 0, 0.00279419190000001, 0.0015781779, 0.000483097380000002, 
8.19204600000003e-05, 0, 0, 0, 0.00279419190000001, 0.00315635580000001, 
0.0229471255500001, 8.19204600000003e-05, 0, 0, 0, 0.00111767676, 
0.000473453370000001, 0.000483097380000002, 0.00794628462000002, 
0, 0.000317130540000001, 0.00835391610000003, 0.000558838380000002, 
5.26059300000002e-05, 0.000241548690000001, 8.19204600000003e-05, 
0.0394039900000002), .Dim = c(7L, 7L)), structure(c(0.002476145832, 
0.0247655042514, 0.0030350355084, 0, 0, 0, 0, 0.02785664061, 
0.784240967961, 0.0030350355084, 0, 0, 0, 0, 0.000309518229, 
0.00825516808380001, 0.037937943855, 0, 0, 0, 0, 0, 0, 0.00252919625700001, 
0.001481216292, 0.000579591874200002, 0.0001002051213, 0, 0, 
0, 0.00252919625700001, 0.00296243258400001, 0.0275306140245001, 
0.0001002051213, 0, 0, 0, 0.0010116785028, 0.000444364887600002, 
0.000579591874200002, 0.00971989676610003, 0, 0.000309518229000001, 
0.00825516808380003, 0.000505839251400002, 4.93738764000002e-05, 
0.000289795937100001, 0.0001002051213, 0.0490099501000002), .Dim = c(7L, 
7L)), structure(c(0.002422134847344, 0.024453979322382, 0.002790157810068, 
0, 0, 0, 0, 0.02724901703262, 0.77437601187543, 0.002790157810068, 
0, 0, 0, 0, 0.000302766855918, 0.00815132644079401, 0.03487697262585, 
0, 0, 0, 0, 0, 0, 0.00232513150839001, 0.00140706286335, 0.000662448959736002, 
0.000117555320307, 0, 0, 0, 0.00232513150839001, 0.00281412572670001, 
0.0314663255874601, 0.000117555320307, 0, 0, 0, 0.000930052603356003, 
0.000422118859005001, 0.000662448959736002, 0.011402866069779, 
0, 0.000302766855918001, 0.00815132644079403, 0.000465026301678002, 
4.69020954450002e-05, 0.000331224479868001, 0.000117555320307, 
0.0585198505990002), .Dim = c(7L, 7L)), structure(c(0.00237330175838352, 
0.0241324556015435, 0.00259986395535372, 0, 0, 0, 0, 0.0266996447818146, 
0.764194427382212, 0.00259986395535372, 0, 0, 0, 0, 0.00029666271979794, 
0.00804415186718119, 0.0324982994419215, 0, 0, 0, 0, 0, 0, 0.00216655329612811, 
0.0013536595955349, 0.000734462762857142, 0.000134174864918761, 
0, 0, 0, 0.00216655329612811, 0.00270731919106981, 0.0348869812357143, 
0.000134174864918761, 0, 0, 0, 0.000866621318451243, 0.000406097878660471, 
0.000734462762857143, 0.0130149618971198, 0, 0.000296662719797941, 
0.00804415186718121, 0.000433310659225622, 4.51219865178302e-05, 
0.000367231381428571, 0.000134174864918761, 0.0679346520930103
), .Dim = c(7L, 7L)), structure(c(0.00232844970522246, 0.0238048180835814, 
0.00245034684173404, 0, 0, 0, 0, 0.0261950591837527, 0.753819239313411, 
0.00245034684173404, 0, 0, 0, 0, 0.000291056213152808, 0.00793493936119381, 
0.0306293355216755, 0, 0, 0, 0, 0, 0, 0.00204195570144504, 0.00131665515583167, 
0.000797900571756619, 0.000150221438570886, 0, 0, 0, 0.00204195570144504, 
0.00263331031166335, 0.0379002771584394, 0.000150221438570886, 
0, 0, 0, 0.000816782280578015, 0.000394996546749502, 0.000797900571756619, 
0.014571479541376, 0, 0.000291056213152809, 0.00793493936119384, 
0.000408391140289008, 4.38885051943892e-05, 0.00039895028587831, 
0.000150221438570886, 0.0772553055720802), .Dim = c(7L, 7L)), 
    structure(c(0.00228668917044303, 0.0234739393601669, 0.00233131986576132, 
    0, 0, 0, 0, 0.0257252531674841, 0.743341413071952, 0.00233131986576132, 
    0, 0, 0, 0, 0.000285836146305379, 0.00782464645338899, 0.0291414983220166, 
    0, 0, 0, 0, 0, 0, 0.00194276655480111, 0.00129201986028126, 
    0.000854515292202373, 0.000165811589404601, 0, 0, 0, 0.00194276655480111, 
    0.00258403972056253, 0.0405894763796127, 0.000165811589404601, 
    0, 0, 0, 0.000777106621920444, 0.000387605958084379, 0.000854515292202373, 
    0.0160837241722463, 0, 0.00028583614630538, 0.007824646453389, 
    0.000388553310960222, 4.30673286760422e-05, 0.000427257646101187, 
    0.000165811589404601, 0.0864827525163594), .Dim = c(7L, 7L
    )), structure(c(0.0022473558717097, 0.023141939583156, 0.00223511885530266, 
    0, 0, 0, 0, 0.0252827535567342, 0.732828086799938, 0.00223511885530266, 
    0, 0, 0, 0, 0.000280919483963713, 0.007713979861052, 0.0279389856912832, 
    0, 0, 0, 0, 0, 0, 0.00186259904608555, 0.00127653398900681, 
    0.00090564188488762, 0.000181029520444535, 0, 0, 0, 0.00186259904608555, 
    0.00255306797801361, 0.0430179895321619, 0.000181029520444535, 
    0, 0, 0, 0.00074503961843422, 0.000382960196702042, 0.00090564188488762, 
    0.0175598634831199, 0, 0.000280919483963714, 0.00771397986105202, 
    0.000372519809217111, 4.25511329668936e-05, 0.00045282094244381, 
    0.000181029520444535, 0.095617924991196), .Dim = c(7L, 7L
    )), structure(c(0.00220995314481346, 0.0228103787763592, 
    0.00215603310217793, 0, 0, 0, 0, 0.0248619728791515, 0.722328661251376, 
    0.00215603310217793, 0, 0, 0, 0, 0.000276244143101683, 0.00760345959211976, 
    0.0269504137772242, 0, 0, 0, 0, 0, 0, 0.00179669425181495, 
    0.00126774133212735, 0.000952293721534112, 0.000195935051831438, 
    0, 0, 0, 0.00179669425181495, 0.00253548266425471, 0.0452339517728703, 
    0.000195935051831438, 0, 0, 0, 0.00071867770072598, 0.000380322399638206, 
    0.000952293721534112, 0.0190057000276494, 0, 0.000276244143101684, 
    0.00760345959211978, 0.00035933885036299, 4.22580444042451e-05, 
    0.000476146860767056, 0.000195935051831438, 0.104661745741284
    ), .Dim = c(7L, 7L)), structure(c(0.00217410920186805, 0.0224804000169812, 
    0.00208980705074673, 0, 0, 0, 0, 0.0244587285210156, 0.71187933387107, 
    0.00208980705074673, 0, 0, 0, 0, 0.000271763650233507, 0.00749346667232707, 
    0.0261225881343342, 0, 0, 0, 0, 0, 0, 0.00174150587562229, 
    0.00126379930719236, 0.000995241274815429, 0.000210569938495478, 
    0, 0, 0, 0.00174150587562229, 0.00252759861438471, 0.0472739605537329, 
    0.000210569938495478, 0, 0, 0, 0.000696602350248915, 0.000379139792157707, 
    0.000995241274815429, 0.0204252840340613, 0, 0.000271763650233508, 
    0.00749346667232709, 0.000348301175124457, 4.21266435730786e-05, 
    0.000497620637407715, 0.000210569938495478, 0.113615128283871
    ), .Dim = c(7L, 7L)), structure(c(0.00213954530156768, 0.022152836083285, 
    0.00203326910741369, 0, 0, 0, 0, 0.0240698846426364, 0.701506475970691, 
    0.00203326910741369, 0, 0, 0, 0, 0.00026744316269596, 0.00738427869442834, 
    0.0254158638426711, 0, 0, 0, 0, 0, 0, 0.00169439092284474, 
    0.00126333491883767, 0.00103507269964471, 0.000224962674512834, 
    0, 0, 0, 0.00169439092284474, 0.00252666983767533, 0.0491659532331236, 
    0.000224962674512834, 0, 0, 0, 0.000677756369137898, 0.000379000475651299, 
    0.00103507269964471, 0.0218213794277449, 0, 0.000267443162695961, 
    0.00738427869442836, 0.000338878184568949, 4.21111639612555e-05, 
    0.000517536349822354, 0.000224962674512834, 0.122478977001033
    ), .Dim = c(7L, 7L)), structure(c(0.00210605203938131, 0.0218282888916222, 
    0.00198405514198772, 0, 0, 0, 0, 0.0236930854430397, 0.691229148234704, 
    0.00198405514198772, 0, 0, 0, 0, 0.000263256504922664, 0.00727609629720742, 
    0.0248006892748465, 0, 0, 0, 0, 0, 0, 0.00165337928498977, 
    0.00126532836475198, 0.00107223953336313, 0.000239132089721788, 
    0, 0, 0, 0.00165337928498977, 0.00253065672950397, 0.0509313778347487, 
    0.000239132089721788, 0, 0, 0, 0.00066135171399591, 0.000379598509425595, 
    0.00107223953336313, 0.0231958127030134, 0, 0.000263256504922665, 
    0.00727609629720744, 0.000330675856997955, 4.21776121583995e-05, 
    0.000536119766681565, 0.000239132089721788, 0.131254187231022
    ), .Dim = c(7L, 7L)), structure(c(0.0020734716858393, 0.0215071886645919, 
    0.0019404025246186, 0, 0, 0, 0, 0.0233265564656921, 0.681060974378745, 
    0.0019404025246186, 0, 0, 0, 0, 0.000259183960729913, 0.00716906288819732, 
    0.0242550315577325, 0, 0, 0, 0, 0, 0, 0.00161700210384883, 
    0.001269023781848, 0.00110709091877928, 0.00025309002459798, 
    0, 0, 0, 0.00161700210384884, 0.00253804756369601, 0.052586818642016, 
    0.00025309002459798, 0, 0, 0, 0.000646800841539534, 0.000380707134554401, 
    0.00110709091877928, 0.0245497323860041, 0, 0.000259183960729914, 
    0.00716906288819735, 0.000323400420769767, 4.23007927282668e-05, 
    0.000553545459389642, 0.000253090024597981, 0.139941645358712
    ), .Dim = c(7L, 7L)), structure(c(0.00204168503000399, 0.0211898380010716, 
    0.00190099670439958, 0, 0, 0, 0, 0.0229689565875448, 0.671011536700602, 
    0.00190099670439958, 0, 0, 0, 0, 0.000255210628750499, 0.00706327933369056, 
    0.0237624588049948, 0, 0, 0, 0, 0, 0, 0.00158416392033299, 
    0.00127386204872223, 0.00113989916668318, 0.000266843312808773, 
    0, 0, 0, 0.00158416392033299, 0.00254772409744446, 0.0541452104174509, 
    0.000266843312808773, 0, 0, 0, 0.000633665568133196, 0.000382158614616669, 
    0.00113989916668318, 0.025883801342451, 0, 0.000255210628750499, 
    0.00706327933369058, 0.000316832784066598, 4.24620682907411e-05, 
    0.000569949583341588, 0.000266843312808773, 0.148542228905125
    ), .Dim = c(7L, 7L)), structure(c(0.00201060157883802, 0.0208764446997764, 
    0.00186485692604615, 0, 0, 0, 0, 0.0226192677619277, 0.66108741549292, 
    0.00186485692604615, 0, 0, 0, 0, 0.000251325197354753, 0.00695881489992548, 
    0.0233107115755769, 0, 0, 0, 0, 0, 0, 0.0015540474383718, 
    0.00127943053456415, 0.00117087883496074, 0.00028039524691884, 
    0, 0, 0, 0.0015540474383718, 0.0025588610691283, 0.0556167446606352, 
    0.00028039524691884, 0, 0, 0, 0.000621618975348718, 0.000383829160369245, 
    0.00117087883496074, 0.0271983389511275, 0, 0.000251325197354753, 
    0.0069588148999255, 0.000310809487674359, 4.26476844854717e-05, 
    0.000585439417480371, 0.000280395246918841, 0.157056806616074
    ), .Dim = c(7L, 7L)), structure(c(0.00198015225637285, 0.0205671462054268, 
    0.00183125110037143, 0, 0, 0, 0, 0.0222767128841945, 0.651292963171849, 
    0.00183125110037143, 0, 0, 0, 0, 0.000247519032046606, 0.00685571540180894, 
    0.0228906387546428, 0, 0, 0, 0, 0, 0, 0.00152604258364286, 
    0.00128542561644466, 0.00120020096830108, 0.000293746659218062, 
    0, 0, 0, 0.00152604258364286, 0.00257085123288932, 0.0570095459943015, 
    0.000293746659218062, 0, 0, 0, 0.000610417033457144, 0.000385627684933398, 
    0.00120020096830108, 0.0284934259441521, 0, 0.000247519032046607, 
    0.00685571540180897, 0.000305208516728572, 4.28475205481554e-05, 
    0.000600100484150542, 0.000293746659218063, 0.165486238549913
    ), .Dim = c(7L, 7L)), structure(c(0.00195028396497369, 0.0202620278146924, 
    0.0017996323913099, 0, 0, 0, 0, 0.021940694605954, 0.641630880798594, 
    0.0017996323913099, 0, 0, 0, 0, 0.000243785495621711, 0.00675400927156415, 
    0.0224954048913738, 0, 0, 0, 0, 0, 0, 0.00149969365942492, 
    0.001291624748282, 0.00122800372940103, 0.000306896716308437, 
    0, 0, 0, 0.00149969365942492, 0.002583249496564, 0.0583301771465491, 
    0.000306896716308437, 0, 0, 0, 0.000599877463769969, 0.0003874874244846, 
    0.00122800372940103, 0.0297689814819183, 0, 0.000243785495621712, 
    0.00675400927156418, 0.000299938731884985, 4.30541582760667e-05, 
    0.000614001864700517, 0.000306896716308437, 0.173831376164414
    ), .Dim = c(7L, 7L)), structure(c(0.00192095553367808, 0.0199611362338757, 
    0.00176959197951358, 0, 0, 0, 0, 0.0216107497538784, 0.632102647406065, 
    0.00176959197951358, 0, 0, 0, 0, 0.000240119441709761, 0.00665371207795859, 
    0.0221198997439197, 0, 0, 0, 0, 0, 0, 0.00147465998292799, 
    0.00129786565602492, 0.00125440034037693, 0.00031984350099574, 
    0, 0, 0, 0.00147465998292799, 0.00259573131204984, 0.0595840161679042, 
    0.00031984350099574, 0, 0, 0, 0.000589863993171195, 0.000389359696807475, 
    0.00125440034037693, 0.0310248195965868, 0, 0.000240119441709761, 
    0.00665371207795861, 0.000294931996585597, 4.3262188534164e-05, 
    0.000627200170188465, 0.00031984350099574, 0.18209306240277
    ), .Dim = c(7L, 7L)), structure(c(0.00189213469976539, 0.0196644896741837, 
    0.00174082387581528, 0, 0, 0, 0, 0.0212865153723607, 0.622708839682484, 
    0.00174082387581528, 0, 0, 0, 0, 0.000236516837470674, 0.00655482989139458, 
    0.0217602984476911, 0, 0, 0, 0, 0, 0, 0.00145068656317941, 
    0.00130403084409767, 0.00127948501927755, 0.000332584436269423, 
    0, 0, 0, 0.00145068656317941, 0.00260806168819534, 0.0607755384156838, 
    0.000332584436269424, 0, 0, 0, 0.000580274625271763, 0.000391209253229302, 
    0.00127948501927755, 0.0322606903181341, 0, 0.000236516837470675, 
    0.0065548298913946, 0.000290137312635882, 4.34676948032558e-05, 
    0.000639742509638778, 0.000332584436269424, 0.190272131778742
    ), .Dim = c(7L, 7L)), structure(c(0.00186379585998115, 0.0193720853679198, 
    0.00171309871059338, 0, 0, 0, 0, 0.0209677034247879, 0.613449369984127, 
    0.00171309871059338, 0, 0, 0, 0, 0.000232974482497644, 0.0064573617893066, 
    0.0214137338824172, 0, 0, 0, 0, 0, 0, 0.00142758225882782, 
    0.00131003605884722, 0.00130333742206656, 0.000345116592159127, 
    0, 0, 0, 0.00142758225882782, 0.00262007211769443, 0.0619085275481616, 
    0.000345116592159127, 0, 0, 0, 0.000571032903531128, 0.000393010817654165, 
    0.00130333742206656, 0.0334763094394353, 0, 0.000232974482497645, 
    0.00645736178930663, 0.000285516451765564, 4.36678686282406e-05, 
    0.00065166871103328, 0.000345116592159127, 0.198369410460955
    ), .Dim = c(7L, 7L)), structure(c(0.00183591839507955, 0.0190839051635852, 
    0.00168624420925329, 0, 0, 0, 0, 0.0206540819446449, 0.604323663513533, 
    0.00168624420925329, 0, 0, 0, 0, 0.000229489799384944, 0.00636130172119509, 
    0.0210780526156661, 0, 0, 0, 0, 0, 0, 0.00140520350771108, 
    0.00131582169957022, 0.00132602597033686, 0.000357436905826872, 
    0, 0, 0, 0.00140520350771108, 0.00263164339914043, 0.0629862335910008, 
    0.000357436905826872, 0, 0, 0, 0.000562081403084431, 0.000394746509871065, 
    0.00132602597033686, 0.0346713798652065, 0, 0.000229489799384944, 
    0.00636130172119511, 0.000281040701542216, 4.38607233190073e-05, 
    0.00066301298516843, 0.000357436905826872, 0.206385716356345
    ), .Dim = c(7L, 7L)), structure(c(0.00180848542143345, 0.0187999196900229, 
    0.00166013064817477, 0, 0, 0, 0, 0.0203454609911263, 0.595330790184059, 
    0.00166013064817477, 0, 0, 0, 0, 0.000226060677679181, 0.00626663989667432, 
    0.0207516331021846, 0, 0, 0, 0, 0, 0, 0.00138344220681231, 
    0.00132134642503351, 0.00134761034807358, 0.000369542337484989, 
    0, 0, 0, 0.00138344220681231, 0.00264269285006702, 0.0640114915334953, 
    0.000369542337484989, 0, 0, 0, 0.000553376882724924, 0.000396403927510052, 
    0.00134761034807358, 0.0358456067360439, 0, 0.000226060677679182, 
    0.00626663989667434, 0.000276688441362462, 4.40448808344503e-05, 
    0.000673805174036793, 0.000369542337484989, 0.214321859192782
    ), .Dim = c(7L, 7L)), structure(c(0.00178148286077049, 0.0185200914547008, 
    0.00163466002059228, 0, 0, 0, 0, 0.020041682183668, 0.586469562732192, 
    0.00163466002059228, 0, 0, 0, 0, 0.000222685357596312, 0.00617336381823361, 
    0.0204332502574036, 0, 0, 0, 0, 0, 0, 0.00136221668382691, 
    0.00132658239522132, 0.00136814337855719, 0.000381429978943525, 
    0, 0, 0, 0.00136221668382691, 0.00265316479044264, 0.0649868104814666, 
    0.000381429978943525, 0, 0, 0, 0.000544886673530764, 0.000397974718566395, 
    0.00136814337855719, 0.0369987079575219, 0, 0.000222685357596313, 
    0.00617336381823363, 0.000272443336765382, 4.4219413174044e-05, 
    0.000684071689278596, 0.000381429978943525, 0.222178640600854
    ), .Dim = c(7L, 7L)), structure(c(0.00175489874688509, 0.0182443771480936, 
    0.00160975796599401, 0, 0, 0, 0, 0.0197426109024572, 0.57773860968963, 
    0.00160975796599401, 0, 0, 0, 0, 0.000219362343360636, 0.00608145904936454, 
    0.0201219745749251, 0, 0, 0, 0, 0, 0, 0.00134146497166168, 
    0.00133151173096468, 0.00138767243869359, 0.000393097127281763, 
    0, 0, 0, 0.00134146497166168, 0.00266302346192937, 0.0659144408379457, 
    0.000393097127281763, 0, 0, 0, 0.000536585988664671, 0.000399453519289405, 
    0.00138767243869359, 0.038130421346331, 0, 0.000219362343360637, 
    0.00608145904936455, 0.000268292994332336, 4.43837243654895e-05, 
    0.000693836219346797, 0.000393097127281763, 0.229956854194846
    ), .Dim = c(7L, 7L)), structure(c(0.00172872270887781, 0.0179727293567424, 
    0.00158536775805902, 0, 0, 0, 0, 0.0194481304748754, 0.569136429630177, 
    0.00158536775805902, 0, 0, 0, 0, 0.000216090338609727, 0.00599090978558082, 
    0.0198170969757377, 0, 0, 0, 0, 0, 0, 0.00132113979838252, 
    0.00133612388058052, 0.00140624052797637, 0.000404541332929787, 
    0, 0, 0, 0.00132113979838252, 0.00267224776116103, 0.0667964250788775, 
    0.000404541332929787, 0, 0, 0, 0.000528455919353007, 0.000400837164174154, 
    0.00140624052797637, 0.0392405092941893, 0, 0.000216090338609728, 
    0.00599090978558084, 0.000264227959676504, 4.45374626860172e-05, 
    0.000703120263988185, 0.000404541332929787, 0.237657285652897
    ), .Dim = c(7L, 7L)), structure(c(0.00170294558589434, 0.0177050978358933, 
    0.00156144582599569, 0, 0, 0, 0, 0.0191581378413113, 0.560661431469956, 
    0.00156144582599569, 0, 0, 0, 0, 0.000212868198236793, 0.00590169927863112, 
    0.0195180728249462, 0, 0, 0, 0, 0, 0, 0.00130120485499642, 
    0.00134041366196076, 0.00142388707942702, 0.000415760429056928, 
    0, 0, 0, 0.00130120485499642, 0.00268082732392151, 0.0676346362727833, 
    0.000415760429056928, 0, 0, 0, 0.000520481941998567, 0.000402124098588227, 
    0.00142388707942702, 0.040328761618522, 0, 0.000212868198236794, 
    0.00590169927863114, 0.000260240970999283, 4.46804553986919e-05, 
    0.00071194353971351, 0.000415760429056928, 0.245280712796368
    ), .Dim = c(7L, 7L)), structure(c(0.00167755913982267, 0.0174414304541179, 
    0.00153795841810884, 0, 0, 0, 0, 0.018872540323005, 0.5523119643804, 
    0.00153795841810884, 0, 0, 0, 0, 0.000209694892477834, 0.00581381015137264, 
    0.0192244802263606, 0, 0, 0, 0, 0, 0, 0.00128163201509071, 
    0.00134437980763234, 0.00144064857761516, 0.000426752547385358, 
    0, 0, 0, 0.00128163201509071, 0.00268875961526467, 0.0684308074367203, 
    0.000426752547385359, 0, 0, 0, 0.000512652806036284, 0.000403313942289701, 
    0.00144064857761517, 0.0413949970963798, 0, 0.000209694892477835, 
    0.00581381015137266, 0.000256326403018142, 4.48126602544112e-05, 
    0.000720324288807583, 0.000426752547385359, 0.252827905668405
    ), .Dim = c(7L, 7L)), structure(c(0.00165255584096395, 0.0171816738936454, 
    0.00151487911621266, 0, 0, 0, 0, 0.0185912532108445, 0.544086339965438, 
    0.00151487911621266, 0, 0, 0, 0, 0.000206569480120494, 0.00572722463121515, 
    0.0189359889526583, 0, 0, 0, 0, 0, 0, 0.00126239926351056, 
    0.00134802388431707, 0.00145655903228922, 0.000437516124223209, 
    0, 0, 0, 0.00126239926351056, 0.00269604776863414, 0.069186554033738, 
    0.000437516124223209, 0, 0, 0, 0.000504959705404222, 0.000404407165295121, 
    0.00145655903228922, 0.0424390640496513, 0, 0.000206569480120495, 
    0.00572722463121516, 0.000252479852702111, 4.49341294772357e-05, 
    0.000728279516144611, 0.00043751612422321, 0.260299626611721
    ), .Dim = c(7L, 7L)), structure(c(0.00162792870806576, 0.0169257741687748, 
    0.00149218698383963, 0, 0, 0, 0, 0.0183141979657398, 0.53598284867787, 
    0.00149218698383963, 0, 0, 0, 0, 0.000203491088508221, 0.00564192472292496, 
    0.0186523372979955, 0, 0, 0, 0, 0, 0, 0.0012434891531997, 
    0.00135134949130202, 0.00147165034380212, 0.000448049899526399, 
    0, 0, 0, 0.0012434891531997, 0.00270269898260403, 0.0699033913306006, 
    0.000448049899526399, 0, 0, 0, 0.00049739566127988, 0.000405404847390605, 
    0.00147165034380212, 0.0434608402540607, 0, 0.000203491088508221, 
    0.00564192472292498, 0.00024869783063994, 4.50449830434006e-05, 
    0.00073582517190106, 0.000448049899526399, 0.267696630345603
    ), .Dim = c(7L, 7L)), structure(c(0.00160367118885442, 0.0166736770088235, 
    0.00146986518656572, 0, 0, 0, 0, 0.0180413008746122, 0.527999771946077, 
    0.00146986518656572, 0, 0, 0, 0, 0.000200458898606803, 0.00555789233627451, 
    0.0183733148320715, 0, 0, 0, 0, 0, 0, 0.00122488765547143, 
    0.00135436166634907, 0.00148595258731861, 0.000458352911065333, 
    0, 0, 0, 0.00122488765547143, 0.00270872333269814, 0.0705827478976342, 
    0.000458352911065333, 0, 0, 0, 0.000489955062188574, 0.000406308499904721, 
    0.00148595258731861, 0.0444602323733373, 0, 0.000200458898606803, 
    0.00555789233627452, 0.000244977531094287, 4.51453888783024e-05, 
    0.000742976293659308, 0.000458352911065333, 0.275019664042147
    ), .Dim = c(7L, 7L)), structure(c(0.00157977707073949, 0.0164253281402176, 
    0.00144789996401716, 0, 0, 0, 0, 0.0177724920458193, 0.520135391106892, 
    0.00144789996401716, 0, 0, 0, 0, 0.000197472133842437, 0.00547510938007256, 
    0.0180987495502146, 0, 0, 0, 0, 0, 0, 0.00120658330334764, 
    0.00135706644606134, 0.00149949423593738, 0.000468424485227491, 
    0, 0, 0, 0.00120658330334764, 0.00271413289212267, 0.0712259762070256, 
    0.000468424485227491, 0, 0, 0, 0.000482633321339057, 0.0004071199338184, 
    0.00149949423593738, 0.0454371750670667, 0, 0.000197472133842437, 
    0.00547510938007257, 0.000241316660669528, 4.52355482020445e-05, 
    0.000749747117968691, 0.000468424485227492, 0.282269467401726
    ), .Dim = c(7L, 7L)), structure(c(0.00155624041399795, 0.0161806734935019, 
    0.00142627986384777, 0, 0, 0, 0, 0.0175077046574769, 0.512387993960893, 
    0.00142627986384777, 0, 0, 0, 0, 0.000194530051749744, 0.0053935578311673, 
    0.0178284982980972, 0, 0, 0, 0, 0, 0, 0.00118856655320648, 
    0.00135947054117216, 0.00151230233775447, 0.000478264225581615, 
    0, 0, 0, 0.00118856655320648, 0.00271894108234431, 0.0718343610433372, 
    0.000478264225581615, 0, 0, 0, 0.000475426621282593, 0.000407841162351646, 
    0.00151230233775447, 0.0463916298814167, 0, 0.000194530051749744, 
    0.00539355783116731, 0.000237713310641297, 4.53156847057385e-05, 
    0.000756151168877235, 0.000478264225581616, 0.289446772727709
    ), .Dim = c(7L, 7L)), structure(c(0.00153305550170781, 0.0159396593544665, 
    0.00140499517086085, 0, 0, 0, 0, 0.0172468743942128, 0.504755879558106, 
    0.00140499517086085, 0, 0, 0, 0, 0.000191631937713476, 0.00531321978482218, 
    0.0175624396357607, 0, 0, 0, 0, 0, 0, 0.00117082930905071, 
    0.00136158109731442, 0.00152440265808939, 0.000487872000028054, 
    0, 0, 0, 0.00117082930905072, 0.00272316219462883, 0.0724091262592462, 
    0.000487872000028054, 0, 0, 0, 0.000468331723620286, 0.000408474329194325, 
    0.00152440265808939, 0.0473235840027212, 0, 0.000191631937713477, 
    0.00531321978482219, 0.000234165861810143, 4.53860365771472e-05, 
    0.000762201329044697, 0.000487872000028054, 0.296552305000431
    ), .Dim = c(7L, 7L)), structure(c(0.00151021680216281, 0.0157022324736954, 
    0.00138403748149778, 0, 0, 0, 0, 0.0169899390243317, 0.497237361667021, 
    0.00138403748149778, 0, 0, 0, 0, 0.000188777100270352, 0.00523407749123181, 
    0.0173004685187223, 0, 0, 0, 0, 0, 0, 0.00115336456791482, 
    0.00136340551934477, 0.00153581979525908, 0.000497247927136252, 
    0, 0, 0, 0.00115336456791482, 0.00272681103868955, 0.0729514402748061, 
    0.000497247927136252, 0, 0, 0, 0.000461345827165928, 0.000409021655803432, 
    0.00153581979525908, 0.0482330489322165, 0, 0.000188777100270352, 
    0.00523407749123182, 0.000230672913582964, 4.54468506448258e-05, 
    0.000767909897629538, 0.000497247927136252, 0.303586781950427
    ), .Dim = c(7L, 7L)), structure(c(0.00148771894058848, 0.0154683401451855, 
    0.00136339938661346, 0, 0, 0, 0, 0.0167368380816204, 0.489830771264208, 
    0.00136339938661346, 0, 0, 0, 0, 0.00018596486757356, 0.00515611338172851, 
    0.0170424923326683, 0, 0, 0, 0, 0, 0, 0.00113616615551122, 
    0.00136495134289648, 0.00154657727617093, 0.000506392362104449, 
    0, 0, 0, 0.00113616615551122, 0.00272990268579295, 0.0734624206181194, 
    0.000506392362104449, 0, 0, 0, 0.000454466462204489, 0.000409485402868943, 
    0.00154657727617093, 0.0491200591241316, 0, 0.000185964867573561, 
    0.00515611338172852, 0.000227233231102245, 4.54983780965492e-05, 
    0.000773288638085467, 0.000506392362104449, 0.310550914130923
    ), .Dim = c(7L, 7L)), structure(c(0.001465556677791, 0.0152379302619733, 
    0.00134307423491822, 0, 0, 0, 0, 0.0164875126251487, 0.482534458295819, 
    0.00134307423491822, 0, 0, 0, 0, 0.000183194584723875, 0.00507931008732443, 
    0.0167884279364778, 0, 0, 0, 0, 0, 0, 0.00111922852909852, 
    0.00136622614100492, 0.00155669763643056, 0.000515305882653759, 
    0, 0, 0, 0.00111922852909852, 0.00273245228200985, 0.0739431377304516, 
    0.000515305882653759, 0, 0, 0, 0.000447691411639409, 0.000409867842301477, 
    0.00155669763643056, 0.0499846706174146, 0, 0.000183194584723875, 
    0.00507931008732444, 0.000223845705819704, 4.55408713668308e-05, 
    0.00077834881821528, 0.000515305882653759, 0.317445404989613
    ), .Dim = c(7L, 7L)), structure(c(0.0014437248939746, 0.0150109513546766, 
    0.00132305595651156, 0, 0, 0, 0, 0.0162419050572142, 0.475346792898092, 
    0.00132305595651156, 0, 0, 0, 0, 0.000180465611746825, 0.00500365045155887, 
    0.0165381994563946, 0, 0, 0, 0, 0, 0, 0.00110254663042631, 
    0.00136723745675633, 0.00156620248848427, 0.000523989275077861, 
    0, 0, 0, 0.00110254663042631, 0.00273447491351266, 0.074394618203003, 
    0.000523989275077861, 0, 0, 0, 0.000441018652170522, 0.000410171237026899, 
    0.00156620248848427, 0.0508269596825525, 0, 0.000180465611746825, 
    0.00500365045155888, 0.000220509326085261, 4.55745818918776e-05, 
    0.000783101244242137, 0.000523989275077861, 0.324270950939717
    ), .Dim = c(7L, 7L)), structure(c(0.00142221857641302, 0.0147873526173545, 
    0.00130333893118201, 0, 0, 0, 0, 0.0159999589846465, 0.468266166216227, 
    0.00130333893118201, 0, 0, 0, 0, 0.000177777322051628, 0.00492911753911819, 
    0.0162917366397752, 0, 0, 0, 0, 0, 0, 0.00108611577598502, 
    0.00136799275522343, 0.0015751125804404, 0.000532443520602342, 
    0, 0, 0, 0.00108611577598502, 0.00273598551044686, 0.0748178475709188, 
    0.000532443520602342, 0, 0, 0, 0.000434446310394006, 0.000410397826567029, 
    0.0015751125804404, 0.0516470214984272, 0, 0.000177777322051628, 
    0.0049291175391182, 0.000217223155197003, 4.55997585074477e-05, 
    0.000787556290220198, 0.000532443520602342, 0.33102824143032
    ), .Dim = c(7L, 7L)), structure(c(0.00140103280999597, 0.0145670839239617, 
    0.0012839178900567, 0, 0, 0, 0, 0.0157616191124546, 0.461290990925453, 
    0.0012839178900567, 0, 0, 0, 0, 0.000175129101249496, 0.00485569464132057, 
    0.0160489736257088, 0, 0, 0, 0, 0, 0, 0.00106993157504725, 
    0.00136849938967535, 0.00158344784755906, 0.000540669782158286, 
    0, 0, 0, 0.00106993157504725, 0.00273699877935071, 0.0752137727590554, 
    0.000540669782158286, 0, 0, 0, 0.000427972630018901, 0.000410549816902607, 
    0.00158344784755906, 0.0524449688693537, 0, 0.000175129101249496, 
    0.00485569464132057, 0.000213986315009451, 4.56166463225119e-05, 
    0.00079172392377953, 0.000540669782158286, 0.337717959016017
    ), .Dim = c(7L, 7L)), structure(c(0.00138016276992115, 0.0143500958378389, 
    0.00126478784209673, 0, 0, 0, 0, 0.0155268311616129, 0.454419701531566, 
    0.00126478784209673, 0, 0, 0, 0, 0.000172520346240144, 0.00478336527927965, 
    0.0158098480262091, 0, 0, 0, 0, 0, 0, 0.00105398986841394, 
    0.00136876457833198, 0.00159122745791223, 0.000548669391638343, 
    0, 0, 0, 0.00105398986841394, 0.00273752915666397, 0.075583304250831, 
    0.000548669391638343, 0, 0, 0, 0.000421595947365577, 0.000410629373499596, 
    0.00159122745791223, 0.0532209309889193, 0, 0.000172520346240144, 
    0.00478336527927966, 0.000210797973682789, 4.56254859443995e-05, 
    0.000795613728956116, 0.000548669391638343, 0.344340779425857
    ), .Dim = c(7L, 7L)), structure(c(0.00135960371598854, 0.0141363396160583, 
    0.00124594401910373, 0, 0, 0, 0, 0.0152955418048711, 0.447650754508512, 
    0.00124594401910373, 0, 0, 0, 0, 0.000169950464498568, 0.00471211320535276, 
    0.0155743002387967, 0, 0, 0, 0, 0, 0, 0.00103828668258645, 
    0.00136879538888895, 0.00159846985335095, 0.000556443837676967, 
    0, 0, 0, 0.00103828668258645, 0.0027375907777779, 0.07592731803417, 
    0.000556443837676967, 0, 0, 0, 0.000415314673034579, 0.000410638616666685, 
    0.00159846985335095, 0.0539750522546657, 0, 0.000169950464498568, 
    0.00471211320535277, 0.000207657336517289, 4.5626512962965e-05, 
    0.000799234926675473, 0.000556443837676967, 0.350897371631598
    ), .Dim = c(7L, 7L)), structure(c(0.00133935098809204, 0.0139257672099746, 
    0.00122738183451888, 0, 0, 0, 0, 0.0150676986160355, 0.440982628315862, 
    0.00122738183451888, 0, 0, 0, 0, 0.000167418873511506, 0.00464192240332487, 
    0.015342272931486, 0, 0, 0, 0, 0, 0, 0.0010228181954324, 
    0.00136859872875099, 0.00160519278664422, 0.00056399475397718, 
    0, 0, 0, 0.0010228181954324, 0.00273719745750199, 0.0762466573656007, 
    0.00056399475397718, 0, 0, 0, 0.000409127278172961, 0.000410579618625298, 
    0.00160519278664423, 0.0547074911357864, 0, 0.000167418873511506, 
    0.00464192240332488, 0.000204563639086481, 4.56199576250331e-05, 
    0.000802596393322112, 0.00056399475397718, 0.357388397915282
    ), .Dim = c(7L, 7L)), structure(c(0.00131940000260684, 0.0137183312629925, 
    0.00120909685249934, 0, 0, 0, 0, 0.014843250029327, 0.434413823328096, 
    0.00120909685249934, 0, 0, 0, 0, 0.000164925000325856, 0.00457277708766417, 
    0.0151137106562418, 0, 0, 0, 0, 0, 0, 0.00100758071041612, 
    0.00136818133944144, 0.00161141335545024, 0.000571323908192289, 
    0, 0, 0, 0.00100758071041612, 0.00273636267888288, 0.0765421343838866, 
    0.000571323908192289, 0, 0, 0, 0.000403032284166448, 0.000410454401832432, 
    0.00161141335545025, 0.055418419094652, 0, 0.000164925000325856, 
    0.00457277708766418, 0.000201516142083224, 4.5606044648048e-05, 
    0.000805706677725122, 0.000571323908192289, 0.363814513936129
    ), .Dim = c(7L, 7L)), structure(c(0.0012997462494479, 0.0135139851062977, 
    0.00119108476465391, 0, 0, 0, 0, 0.0146221453062888, 0.427942861699426, 
    0.00119108476465391, 0, 0, 0, 0, 0.000162468281180987, 0.00450466170209923, 
    0.0148885595581739, 0, 0, 0, 0, 0, 0, 0.000992570637211592, 
    0.00136754979405003, 0.00161714803362756, 0.000578433191361012, 
    0, 0, 0, 0.000992570637211592, 0.00273509958810006, 0.076814531597309, 
    0.000578433191361012, 0, 0, 0, 0.000397028254884637, 0.000410264938215008, 
    0.00161714803362756, 0.0561080195620181, 0, 0.000162468281180987, 
    0.00450466170209923, 0.000198514127442319, 4.55849931350009e-05, 
    0.000808574016813779, 0.000578433191361012, 0.370176368796768
    ), .Dim = c(7L, 7L)), structure(c(0.00128038528963196, 0.0133126827531111, 
    0.00117334137248724, 0, 0, 0, 0, 0.0144043345083595, 0.42156828718185, 
    0.00117334137248724, 0, 0, 0, 0, 0.000160048161203995, 0.00443756091770369, 
    0.0146667671560906, 0, 0, 0, 0, 0, 0, 0.000977784477072705, 
    0.00136671049687506, 0.00162241270027963, 0.000585324607887453, 
    0, 0, 0, 0.000977784477072705, 0.00273342099375011, 0.0770646032632826, 
    0.000585324607887453, 0, 0, 0, 0.000391113790829082, 0.000410013149062517, 
    0.00162241270027963, 0.056776486965083, 0, 0.000160048161203995, 
    0.0044375609177037, 0.000195556895414541, 4.55570165625019e-05, 
    0.000811206350139817, 0.000585324607887453, 0.3764746051088
    ), .Dim = c(7L, 7L)), structure(c(0.00126131275321842, 0.0131143788918809, 
    0.00115586257409989, 0, 0, 0, 0, 0.0141897684737072, 0.415288664909562, 
    0.00115586257409989, 0, 0, 0, 0, 0.000157664094152303, 0.00437145963062698, 
    0.0144482821762487, 0, 0, 0, 0, 0, 0, 0.000963218811749913, 
    0.00136566968463445, 0.00162722266683986, 0.000592000266052542, 
    0, 0, 0, 0.000963218811749913, 0.00273133936926891, 0.0772930766748932, 
    0.000592000266052542, 0, 0, 0, 0.000385287524699965, 0.000409700905390336, 
    0.00162722266683986, 0.0574240258070966, 0, 0.000157664094152303, 
    0.00437145963062698, 0.000192643762349983, 4.55223228211485e-05, 
    0.000813611333419928, 0.000592000266052542, 0.382709859057712
    ), .Dim = c(7L, 7L)), structure(c(0.00124252433753594, 0.0129190288787211, 
    0.00113864435406168, 0, 0, 0, 0, 0.0139783987972793, 0.409102581159501, 
    0.00113864435406168, 0, 0, 0, 0, 0.000155315542191993, 0.0043063429595737, 
    0.014233054425771, 0, 0, 0, 0, 0, 0, 0.0009488702950514, 
    0.00136443342878303, 0.00163159270243929, 0.000598462369040267, 
    0, 0, 0, 0.0009488702950514, 0.00272886685756606, 0.0775006533658663, 
    0.000598462369040267, 0, 0, 0, 0.00037954811802056, 0.000409330028634909, 
    0.00163159270243929, 0.0580508497969059, 0, 0.000155315542191993, 
    0.0043063429595737, 0.00018977405901028, 4.54811142927677e-05, 
    0.000815796351219645, 0.000598462369040267, 0.388882760467135
    ), .Dim = c(7L, 7L)), structure(c(0.0012240158056255, 0.0127265887293253, 
    0.0011216827756522, 0, 0, 0, 0, 0.0137701778132868, 0.4030086430953, 
    0.0011216827756522, 0, 0, 0, 0, 0.000153001975703187, 0.00424219624310843, 
    0.0140210346956525, 0, 0, 0, 0, 0, 0, 0.000934735646376834, 
    0.0013630076385942, 0.00163553705775048, 0.000604713206460007, 
    0, 0, 0, 0.000934735646376834, 0.00272601527718839, 0.0776880102431478, 
    0.000604713206460007, 0, 0, 0, 0.000373894258550734, 0.000408902291578259, 
    0.00163553705775048, 0.0586571810266207, 0, 0.000153001975703187, 
    0.00424219624310843, 0.000186947129275367, 4.54335879531399e-05, 
    0.00081776852887524, 0.000604713206460007, 0.394993932862464
    ), .Dim = c(7L, 7L)), structure(c(0.00120578298484824, 0.0125370151105272, 
    0.00110497397486785, 0, 0, 0, 0, 0.0135650585795427, 0.397005478500027, 
    0.00110497397486785, 0, 0, 0, 0, 0.00015072287310603, 0.00417900503684239, 
    0.0138121746858481, 0, 0, 0, 0, 0, 0, 0.000920811645723206, 
    0.00136139806475446, 0.00163906948746346, 0.000610755146345001, 
    0, 0, 0, 0.000920811645723206, 0.00272279612950891, 0.0778558006545144, 
    0.000610755146345001, 0, 0, 0, 0.000368324658289283, 0.000408419419426337, 
    0.00163906948746346, 0.0592432491954651, 0, 0.00015072287310603, 
    0.0041790050368424, 0.000184162329144641, 4.53799354918152e-05, 
    0.000819534743731731, 0.000610755146345001, 0.401043993533839
    ), .Dim = c(7L, 7L)), structure(c(0.00118782176561946, 0.0123502653316331, 
    0.00108851415574779, 0, 0, 0, 0, 0.0133629948632189, 0.391091735501716, 
    0.00108851415574779, 0, 0, 0, 0, 0.000148477720702433, 0.00411675511054438, 
    0.0136064269468474, 0, 0, 0, 0, 0, 0, 0.000907095129789826, 
    0.00135961030328584, 0.00164220327152183, 0.000616590627606442, 
    0, 0, 0, 0.000907095129789826, 0.00271922060657167, 0.0780046553972869, 
    0.000616590627606442, 0, 0, 0, 0.00036283805191593, 0.000407883090985751, 
    0.00164220327152183, 0.0598092908778249, 0, 0.000148477720702433, 
    0.00411675511054438, 0.000181419025957965, 4.53203434428612e-05, 
    0.000821101635760915, 0.000616590627606442, 0.407033553598501
    ), .Dim = c(7L, 7L)), structure(c(0.00117012810024003, 0.0121662973356205, 
    0.00107229958668565, 0, 0, 0, 0, 0.0131639411277003, 0.385266082294648, 
    0.00107229958668565, 0, 0, 0, 0, 0.000146266012530004, 0.00405543244520683, 
    0.0134037448335707, 0, 0, 0, 0, 0, 0, 0.00089358298890471, 
    0.00135764979966118, 0.0016449512352251, 0.000622222152922484, 
    0, 0, 0, 0.00089358298890471, 0.00271529959932236, 0.0781351836731921, 
    0.000622222152922484, 0, 0, 0, 0.000357433195561884, 0.000407294939898354, 
    0.0016449512352251, 0.0603555488334809, 0, 0.000146266012530004, 
    0.00405543244520683, 0.000178716597780942, 4.52549933220394e-05, 
    0.000822475617612549, 0.000622222152922484, 0.412963218062516
    ), .Dim = c(7L, 7L)), structure(c(0.00115269800180369, 0.011985069690271, 
    0.00105632659747845, 0, 0, 0, 0, 0.0129678525202915, 0.379527206858583, 
    0.00105632659747845, 0, 0, 0, 0, 0.000144087250225462, 0.00399502323009035, 
    0.0132040824684806, 0, 0, 0, 0, 0, 0, 0.000880272164565374, 
    0.00135552185301404, 0.00164732576828683, 0.000627652282041663, 
    0, 0, 0, 0.000880272164565374, 0.00271104370602808, 0.0782479739936246, 
    0.000627652282041663, 0, 0, 0, 0.00035210886582615, 0.000406656555904212, 
    0.00164732576828683, 0.0608822713580413, 0, 0.000144087250225462, 
    0.00399502323009035, 0.000176054432913075, 4.51840617671347e-05, 
    0.000823662884143417, 0.000627652282041663, 0.418833585881891
    ), .Dim = c(7L, 7L)), structure(c(0.00113552754316425, 0.0118065415792906, 
    0.00104059157692778, 0, 0, 0, 0, 0.0127746848605979, 0.373873816677535, 
    0.00104059157692778, 0, 0, 0, 0, 0.000141940942895532, 0.00393551385976353, 
    0.0130073947115973, 0, 0, 0, 0, 0, 0, 0.00086715964743982, 
    0.00135323162037237, 0.00164933884292519, 0.000632883625480584, 
    0, 0, 0, 0.00086715964743982, 0.00270646324074475, 0.0783435950389467, 
    0.000632883625480584, 0, 0, 0, 0.000346863858975928, 0.000405969486111712, 
    0.00164933884292519, 0.0613897116716167, 0, 0.000141940942895532, 
    0.00393551385976353, 0.000173431929487964, 4.51077206790791e-05, 
    0.000824669421462597, 0.000632883625480584, 0.424645250023072
    ), .Dim = c(7L, 7L)), structure(c(0.00111861285595061, 0.0116306727934518, 
    0.00102509097085538, 0, 0, 0, 0, 0.0125843946294444, 0.368304638459308, 
    0.00102509097085538, 0, 0, 0, 0, 0.000139826606993826, 0.00387689093115061, 
    0.0128136371356923, 0, 0, 0, 0, 0, 0, 0.000854242475712819, 
    0.00135078412086539, 0.00165100203105224, 0.000637918838596295, 
    0, 0, 0, 0.000854242475712819, 0.00270156824173078, 0.0784225964749812, 
    0.000637918838596295, 0, 0, 0, 0.000341696990285128, 0.000405235236259617, 
    0.00165100203105224, 0.0618781273438406, 0, 0.000139826606993826, 
    0.00387689093115061, 0.000170848495142564, 4.50261373621797e-05, 
    0.000825501015526119, 0.000637918838596295, 0.430398797522841
    ), .Dim = c(7L, 7L)), structure(c(0.00110195012962063, 0.0114574237217882, 
    0.0010098212804302, 0, 0, 0, 0, 0.012396938958232, 0.362818417856627, 
    0.0010098212804302, 0, 0, 0, 0, 0.000137743766202578, 0.00381914124059608, 
    0.0126227660053775, 0, 0, 0, 0, 0, 0, 0.000841517733691836, 
    0.00134818423986802, 0.00165232652062042, 0.000642760616014376, 
    0, 0, 0, 0.000841517733691836, 0.00269636847973604, 0.07848550972947, 
    0.000642760616014376, 0, 0, 0, 0.000336607093476734, 0.000404455271960407, 
    0.00165232652062042, 0.0623477797533945, 0, 0.000137743766202578, 
    0.00381914124059608, 0.000168303546738367, 4.49394746622674e-05, 
    0.000826163260310211, 0.000642760616014376, 0.436094809547612
    ), .Dim = c(7L, 7L)), structure(c(0.00108553561054712, 0.0112867553428587, 
    0.000994779060730572, 0, 0, 0, 0, 0.0122122756186551, 0.357413919190525, 
    0.000994779060730572, 0, 0, 0, 0, 0.000135691951318391, 0.00376225178095289, 
    0.0124347382591321, 0, 0, 0, 0, 0, 0, 0.00082898255060881, 
    0.0013454367330584, 0.00165332313117825, 0.00064741168639452, 
    0, 0, 0, 0.00082898255060881, 0.00269087346611679, 0.0785328487309667, 
    0.00064741168639452, 0, 0, 0, 0.000331593020243524, 0.000403631019917519, 
    0.00165332313117825, 0.0627989335802685, 0, 0.000135691951318391, 
    0.00376225178095289, 0.000165796510121762, 4.48478911019466e-05, 
    0.000826661565589123, 0.00064741168639452, 0.441733861452136
    ), .Dim = c(7L, 7L))), logZ = -1.33226762955019e-15), .Names = c("decode", 
"node.bel", "edge.bel", "logZ"))


Chain <- list()
Chain$crf <- crf
Chain$answer <- answer
save(Chain, file="Chain.RData")
