\name{sub.crf}
\alias{sub.crf}
\title{Make sub CRF}
\usage{
sub.crf(crf, subset)
}
\arguments{
  \item{crf}{The CRF generated by \code{\link{make.crf}}}

  \item{subset}{The vector of selected node ids}
}
\value{
The function will return a new CRF with additional
components: \item{original}{The original CRF data.}
\item{node.id}{The vector of the original node ids for
nodes in the new CRF.} \item{node.map}{The vector of the
new node ids for nodes in the original CRF.}
\item{edge.id}{The vector of the original edge ids for
edges in the new CRF.} \item{edge.map}{The vector of the
new edge ids for edges in the original CRF.}
}
\description{
Generate sub CRF by selecting some nodes
}
\details{
The function will generate a new CRF from a given CRF by
selecting some nodes. The vector \code{subset} contains the
node ids selected to generate the new CRF. Unlike
\code{\link{clamp.crf}}, the potentials of remainning nodes
and edges are untouched.
}
\examples{
library(CRF)
data(Small)
crf <- sub.crf(Small$crf, c(2, 3))
}
\seealso{
\code{\link{make.crf}}, \code{\link{clamp.crf}}
}

