% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{stat_de}
\alias{stat_de}
\title{Compute the Darling-Erdös Statistic}
\usage{
stat_de(dat, a = log, b = log, estimate = FALSE,
  use_kernel_var = FALSE, custom_var = NULL, kernel = "ba",
  bandwidth = "and", get_all_vals = FALSE)
}
\arguments{
\item{dat}{The data vector}

\item{a}{The function that will be composed with
\eqn{l(x) = (2 \log x)^{1/2}}}

\item{b}{The function that will be composed with
\eqn{u(x) = 2 \log x + \frac{1}{2} \log \log x - \frac{1}{2} \log
\pi}}

\item{estimate}{Set to \code{TRUE} to return the estimated location of the
change point}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel methods for long-run
variance estimation (typically used when the data is
believed to be correlated); if \code{FALSE}, then the
long-run variance is estimated using
\eqn{\hat{\sigma}^2_{T,t} = T^{-1}\left(
\sum_{s = 1}^t \left(X_s - \bar{X}_t\right)^2 +
\sum_{s = t + 1}^{T}\left(X_s -
\tilde{X}_{T - t}\right)^2\right)}, where
\eqn{\bar{X}_t = t^{-1}\sum_{s = 1}^t X_s} and
\eqn{\tilde{X}_{T - t} = (T - t)^{-1}
\sum_{s = t + 1}^{T} X_s}}

\item{custom_var}{Can be a vector the same length as \code{dat} consisting of
variance-like numbers at each potential change point (so
each entry of the vector would be the "best estimate" of
the long-run variance if that location were where the
change point occured) or a function taking two parameters
\code{x} and \code{k} that can be used to generate this
vector, with \code{x} representing the data vector and
\code{k} the position of a potential change point; if
\code{NULL}, this argument is ignored}

\item{kernel}{If character, the identifier of the kernel function as used in
\pkg{cointReg} (see \code{\link[cointReg]{getLongRunVar}}); if
function, the kernel function to be used for long-run variance
estimation (default is the Bartlett kernel in \pkg{cointReg})}

\item{bandwidth}{If character, the identifier for how to compute the
bandwidth as defined in \pkg{cointReg} (see
\code{\link[cointReg]{getBandwidth}}); if function, a function
to use for computing the bandwidth; if numeric, the bandwidth
value to use (the default is to use Andrews' method, as used in
\pkg{cointReg})}

\item{get_all_vals}{If \code{TRUE}, return all values for the statistic at
every tested point in the data set}
}
\value{
If both \code{estimate} and \code{get_all_vals} are \code{FALSE}, the
        value of the test statistic; otherwise, a list that contains the test
        statistic and the other values requested (if both are \code{TRUE},
        the test statistic is in the first position and the estimated changg
        point in the second)
}
\description{
This function computes the Darling-Erdös statistic.
}
\details{
If \eqn{\bar{A}_T(\tau, t_T)} is the weighted and trimmed CUSUM statistic
with weighting parameter \eqn{\tau} and trimming parameter \eqn{t_T} (see
\code{\link{stat_Vn}}), then the Darling-Erdös statistic is

\deqn{l(a_T) \bar{A}_T(1/2, 1) - u(b_T)}

with \eqn{l(x) = \sqrt{2 \log x}} and \eqn{u(x) = 2 \log x + \frac{1}{2} \log
\log x - \frac{1}{2} \log \pi} (\eqn{\log x} is the natural logarithm of
\eqn{x}). The parameter \code{a} corresponds to \eqn{a_T} and \code{b} to
\eqn{b_T}; these are both \code{log} by default.

See \insertCite{horvathricemiller19}{CPAT} to learn more.
}
\examples{
CPAT:::stat_de(rnorm(1000))
CPAT:::stat_de(rnorm(1000), use_kernel_var = TRUE, bandwidth = "nw", kernel = "bo")
}
\references{
\insertAllCited{}
}
