% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm.cmp}
\alias{glm.cmp}
\title{COM-Poisson and Zero-Inflated COM-Poisson regression}
\usage{
glm.cmp(formula.lambda, formula.nu = NULL, formula.p = NULL,
  beta.init = NULL, gamma.init = NULL, zeta.init = NULL, ...)
}
\arguments{
\item{formula.lambda}{regression formula linked to \code{log(lambda)}.}

\item{formula.nu}{regression formula linked to \code{log(nu)}. If NULL
(the default), is taken to be intercept only.}

\item{formula.p}{regression formula linked to \code{logit(p)}. If NULL
(the default), zero-inflation term is excluded from the model.}

\item{beta.init}{initial values for regression coefficients of \code{lambda}.}

\item{gamma.init}{initial values for regression coefficients of \code{nu}.}

\item{zeta.init}{initial values for regression coefficients of \code{p}.}

\item{...}{other model parameters, such as data.}
}
\value{
\code{glm.cmp} produces an object of either class 'cmp' or 'zicmp', depending
on whether zero-inflation is used in the model. From this object, coefficients
and other information can be extracted.
}
\description{
Fit COM-Poisson regression using maximum likelihood estimation.
Zero-Inflated COM-Poisson can be fit by specifying a regression for the
overdispersion parameter.
}
\details{
The COM-Poisson regression model is
\deqn{
y_i \sim \rm{CMP}(\lambda_i, \nu_i), \;\;\;
\log \lambda_i = \bm{x}_i^\top \beta, \;\;\;
\log \nu_i = \bm{s}_i^\top \gamma.
}{
y_i ~ CMP(lambda_i, nu_i),
log lambda_i = x_i^T beta,
log nu_i = s_i^T gamma.
}

The Zero-Inflated COM-Poisson regression model assumes that \eqn{y_i} is 0
with probability \eqn{p_i} or \eqn{y_i^*} with probability \eqn{1 - p_i},
where
\deqn{
y_i^* \sim \rm{CMP}(\lambda_i, \nu_i), \;\;\;
\log \lambda_i = \bm{x}_i^\top \beta, \;\;\;
\log \nu_i = \bm{s}_i^\top \gamma, \;\;\;
\log p_i = \bm{w}_i^\top \zeta.
}{
y_i^* ~ CMP(lambda_i, nu_i),
log lambda_i = x_i^T beta,
log nu_i = s_i^T gamma,
log p_i = w_i^T zeta.
}
}
\references{
Kimberly F. Sellers & Galit Shmueli (2010). A Flexible Regression Model for
Count Data. Annals of Applied Statistics, 4(2), 943-961.

Kimberly F. Sellers and Andrew M. Raim (2016). A Flexible Zero-Inflated Model
to Address Data Dispersion. Computational Statistics and Data Analysis, 99,
68-80.
}
\author{
Kimberly Sellers, Thomas Lotze, Andrew Raim
}
