% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jags_picker_2stage.R
\name{jags_picker_2stage}
\alias{jags_picker_2stage}
\title{Set up a Two-Stage Binary Outcome Misclassification \code{jags.model} Object for a Given Prior}
\usage{
jags_picker_2stage(
  prior,
  sample_size,
  dim_x,
  dim_z,
  dim_v,
  n_cat,
  Ystar,
  Ytilde,
  X,
  Z,
  V,
  beta_prior_parameters,
  gamma_prior_parameters,
  delta_prior_parameters,
  number_MCMC_chains,
  model_file,
  display_progress = TRUE
)
}
\arguments{
\item{prior}{A character string specifying the prior distribution for the
\eqn{\beta}, \eqn{\gamma}, and \eqn{\delta} parameters. Options are \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"} (double Exponential, or Weibull).}

\item{sample_size}{An integer value specifying the number of observations in the sample.}

\item{dim_x}{An integer specifying the number of columns of the design matrix of the true outcome mechanism, \code{X}.}

\item{dim_z}{An integer specifying the number of columns of the design matrix of the first-stage observation mechanism, \code{Z}.}

\item{dim_v}{An integer specifying the number of columns of the design matrix of the second-stage observation mechanism, \code{V}.}

\item{n_cat}{An integer specifying the number of categorical values that the true outcome, \code{Y},
and the observed outcomes, \eqn{Y^*} and \eqn{\tilde{Y}}, can take.}

\item{Ystar}{A numeric vector of indicator variables (1, 2) for the first-stage observed
outcome \code{Y*}. The reference category is 2.}

\item{Ytilde}{A numeric vector of indicator variables (1, 2) for the second-stage observed
outcome \eqn{\tilde{Y}}. The reference category is 2.}

\item{X}{A numeric design matrix for the true outcome mechanism.}

\item{Z}{A numeric design matrix for the first-stage observation mechanism.}

\item{V}{A numeric design matrix for the second-stage observation mechanism.}

\item{beta_prior_parameters}{A numeric list of prior distribution parameters
for the \eqn{\beta} terms. For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the first element of the
list should contain a matrix of location, lower bound, mean, or shape parameters,
respectively, for \eqn{\beta} terms.
For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the second element of the
list should contain a matrix of shape, upper bound, standard deviation, or scale parameters,
respectively, for \eqn{\beta} terms.
For prior distribution \code{"t"}, the third element of the list should contain
a matrix of the degrees of freedom for \eqn{\beta} terms.
The third list element should be empty for all other prior distributions.
All matrices in the list should have dimensions \code{dim_x} X \code{n_cat}, and all
elements in the \code{n_cat} column should be set to \code{NA}.}

\item{gamma_prior_parameters}{A numeric list of prior distribution parameters
for the \eqn{\gamma} terms. For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the first element of the
list should contain an array of location, lower bound, mean, or shape parameters,
respectively, for \eqn{\gamma} terms.
For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the second element of the
list should contain an array of shape, upper bound, standard deviation, or scale parameters,
respectively, for \eqn{\gamma} terms.
For prior distribution \code{"t"}, the third element of the list should contain
an array of the degrees of freedom for \eqn{\gamma} terms.
The third list element should be empty for all other prior distributions.
All arrays in the list should have dimensions \code{n_cat} X \code{n_cat} X \code{dim_z},
and all elements in the \code{n_cat} row should be set to \code{NA}.}

\item{delta_prior_parameters}{A numeric list of prior distribution parameters
for the \eqn{\delta} terms. For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the first element of the
list should contain an array of location, lower bound, mean, or shape parameters,
respectively, for \eqn{\delta} terms.
For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the second element of the
list should contain an array of shape, upper bound, standard deviation, or scale parameters,
respectively, for \eqn{\delta} terms.
For prior distribution \code{"t"}, the third element of the list should contain
an array of the degrees of freedom for \eqn{\delta} terms.
The third list element should be empty for all other prior distributions.
All arrays in the list should have dimensions \code{n_cat} X \code{n_cat} X \code{n_cat} X \code{dim_v},
and all elements in the \code{n_cat} row should be set to \code{NA}.}

\item{number_MCMC_chains}{An integer specifying the number of MCMC chains to compute.}

\item{model_file}{A .BUG file and used
for MCMC estimation with \code{rjags}.}

\item{display_progress}{A logical value specifying whether messages should be
displayed during model compilation. The default is \code{TRUE}.}
}
\value{
\code{jags_picker} returns a \code{jags.model} object for a two-stage binary
outcome misclassification model. The object includes the specified
prior distribution, model, number of chains, and data.
}
\description{
Set up a Two-Stage Binary Outcome Misclassification \code{jags.model} Object for a Given Prior
}
