% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_switchgear.R
\name{environmental_cof_ehv_switchgear}
\alias{environmental_cof_ehv_switchgear}
\title{Environmental cost of Failure for EHV swicthgear & 132kV CB}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
environmental_cof_ehv_switchgear(
  ehv_asset_category,
  type_env_factor,
  prox_water,
  bunded
)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV asset category}

\item{type_env_factor}{String The type environment factor of EHV asset category}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 223, page 172, CNAIM, 2017).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
}
\examples{
environmental_cof_ehv_switchgear(ehv_asset_category = "33kV RMU",
type_env_factor = "Oil",
prox_water = 95,
bunded = "Yes")
}
