% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLONETv2_compute_scna_clonality_table.R
\name{compute_scna_clonality_table}
\alias{compute_scna_clonality_table}
\title{Function to compute clonality of somatic copy number data}
\usage{
compute_scna_clonality_table(beta_table, ploidy_table, admixture_table,
  error_tb = error_table, clonality_threshold = 0.85,
  beta_threshold = 0.9, n_digits = 3, n_cores = 1, debug = F)
}
\arguments{
\item{beta_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_beta_table}}}

\item{ploidy_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_ploidy]{compute_ploidy}}}

\item{admixture_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_dna_admixture]{compute_dna_admixture}}}

\item{error_tb}{data.frame that reports for each combination of coverage and
number informative SNPs the expected estimation error around beta. The
data.frame error_tb must contains 3 columns: \describe{ \item{mean.cov}{mean
coverage} \item{n.info.snps}{number of informative SNPs}
\item{adm.estimation.error}{estimated error on computed beta on a segment
with coverage mean.cov and n.info.snps informative SNPs} } Package CLONETv2
have built in error_tb named error_table (default=error_table)}

\item{clonality_threshold}{threshold to discretize continuous clonality value
(default=0.85)}

\item{beta_threshold}{threshold on beta value to determine clonality direction
(default=0.90)}

\item{n_digits}{number of digits in the output table  (default=3)}

\item{n_cores}{number of cores (default=1)}

\item{debug}{return extra columns for debugging (default=F)}
}
\value{
A data.frame that extends input beta_table with columns \describe{
\item{clonality}{estimated fraction of tumor cell with log2 copy number}
\item{clonality.min}{minum estimated fraction of tumor cell with log2 copy
number} \item{clonality.max}{minum estimated fraction of tumor cell with
log2 copy number} \item{clonality.status}{discretized clonality status into
five values: \emph{clonal}, large majority of the tumor cells has the same
copy number; \emph{subclonal}, not all the tumor cells has the same copy
number; \emph{not.analysed}, is is not possible to determine clonality;
\emph{uncertain.clonal} and \emph{uncertain.subclonal} correspond
respectively to \emph{clonal} and \emph{subclonal} populations but with less
reliable clonality estimate } }
}
\description{
This function takes the beta table of a tumor sample together with the
associated ploidy and admixtures tables and computes the clonality of each
segment in the beta table.
}
\examples{
\donttest{

## Compute clonality table with default parameters
scna_clonality_table_toy <- compute_scna_clonality_table(beta_table = bt_toy,
  ploidy_table = pl_table_toy, admixture_table = adm_table_toy)
}
}
\author{
Davide Prandi
}
