% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbsSampler}
\alias{gibbsSampler}
\title{This is the Gibbs sampler for CDSeq.
\code{GibbsSampler} returns estimated GEPs and cell type proportions.}
\usage{
gibbsSampler(
  ALPHA,
  BETA,
  mixtureSamples,
  T,
  NN,
  OUTPUT,
  processID,
  data_block_idx,
  CDSeq_tmp_log,
  write_2_file,
  verbose
)
}
\arguments{
\item{ALPHA}{hyperparameter for cell type proportion.}

\item{BETA}{hyperparameter for cell-type-specific GEPs.}

\item{mixtureSamples}{bulk RNA-seq data in form of read counts.}

\item{T}{number of cell types.}

\item{NN}{number of MCMC iteration.}

\item{OUTPUT}{MCMC progress output control.}

\item{processID}{worker process ID when using parallel computing.}

\item{data_block_idx}{index for data blocks from bulk RNA-seq input.}

\item{CDSeq_tmp_log}{temporary log file recording the workers' jobs.}

\item{write_2_file}{print to progress msg to CDSeq_tmp_log if it is 1, not printing otherwise.}

\item{verbose}{if greater than or euqal to 1, then print working progress in console, otherwise do not print in console.}
}
\value{
random integers  uniformly distributed in 0..(2^32 - 1).
}
\description{
This is the Gibbs sampler for CDSeq.
\code{GibbsSampler} returns estimated GEPs and cell type proportions.
}
